/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Commands;

import dev.atrox.lightchat.HexColor;
import dev.atrox.lightchat.LightChat;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;

public class ReloadCommand
implements CommandExecutor {
    private final LightChat plugin;

    public ReloadCommand(LightChat plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String[] configFiles;
        if (!sender.hasPermission("lightchat.reload")) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&cYou don't have permission to use this command."));
            return true;
        }
        long startTime = System.currentTimeMillis();
        HandlerList.unregisterAll((Plugin)this.plugin);
        this.plugin.reloadConfig();
        for (String fileName : configFiles = new String[]{"messages.yml", "antiadvertising.yml", "antitabcomplete.yml", "blockcommand.yml", "autoresponder.yml", "antiswear.yml", "data.yml"}) {
            this.plugin.reloadCustomConfig(fileName);
        }
        this.plugin.onDisable();
        this.plugin.onEnable();
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        sender.sendMessage(HexColor.translateAlternateColorCodes('&', String.format("&b\u029f\u026a\u0262\u029c\u1d1b\u1d04\u029c\u1d00\u1d1b\u279c &ahas been successfully reloaded! %dms", duration)));
        return true;
    }
}

