/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Commands;

import dev.atrox.lightchat.HexColor;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ReplyCommand
implements CommandExecutor {
    private final JavaPlugin plugin;
    private static final Map<Player, Player> lastMessageSenderMap = new HashMap<Player, Player>();
    private FileConfiguration messages;

    public ReplyCommand(JavaPlugin plugin) {
        this.plugin = plugin;
        plugin.getCommand("reply").setExecutor((CommandExecutor)this);
        this.reloadMessages();
    }

    public static void setLastMessageSender(Player recipient, Player sender) {
        lastMessageSenderMap.put(recipient, sender);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', this.messages.getString("player-only", "")));
            return true;
        }
        Player playerSender = (Player)sender;
        Player lastSender = lastMessageSenderMap.get(playerSender);
        if (lastSender == null || !lastSender.isOnline()) {
            playerSender.sendMessage(HexColor.translateAlternateColorCodes('&', this.messages.getString("no-reply-player", "")));
            return true;
        }
        if (args.length == 0) {
            playerSender.sendMessage(HexColor.translateAlternateColorCodes('&', this.messages.getString("reply-usage", "")));
            return true;
        }
        StringBuilder messageBuilder = new StringBuilder();
        for (String arg : args) {
            messageBuilder.append(arg).append(" ");
        }
        String message = HexColor.translateAlternateColorCodes('&', messageBuilder.toString().trim());
        String sentFormat = HexColor.translateAlternateColorCodes('&', this.plugin.getConfig().getString("reply_format.sent", "&7[&aYou \u2192 %recipient%&7] &f%message%"));
        String receivedFormat = HexColor.translateAlternateColorCodes('&', this.plugin.getConfig().getString("reply_format.received", "&7[&a%sender% \u2192 You&7] &f%message%"));
        String notificationSound = this.plugin.getConfig().getString("reply_notification.sound", "BLOCK_NOTE_BLOCK_PLING").toUpperCase();
        String senderName = playerSender.getDisplayName();
        String recipientName = lastSender.getDisplayName();
        String formattedSentMessage = sentFormat.replace("%sender%", senderName).replace("%recipient%", recipientName).replace("%message%", message);
        String formattedReceivedMessage = receivedFormat.replace("%sender%", senderName).replace("%message%", message);
        playerSender.sendMessage(formattedSentMessage);
        lastSender.sendMessage(formattedReceivedMessage);
        try {
            Sound sound = Sound.valueOf((String)notificationSound);
            lastSender.playSound(lastSender.getLocation(), sound, 1.0f, 1.0f);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid reply notification sound setting: " + notificationSound);
        }
        return true;
    }

    private void reloadMessages() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
    }
}

