/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Commands;

import dev.atrox.lightchat.HexColor;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ServerInvalidCommandHandler {
    private final JavaPlugin plugin;
    private String unknownCommandMessage;

    public ServerInvalidCommandHandler(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadMessages();
        this.overrideCommandSystem();
    }

    private void loadMessages() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        YamlConfiguration messages = YamlConfiguration.loadConfiguration((File)messagesFile);
        this.unknownCommandMessage = HexColor.translateAlternateColorCodes('&', messages.getString("server-unknown-command", "&cUnknown command. Type &6/help &cfor help."));
    }

    private void overrideCommandSystem() {
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(Bukkit.getServer());
            Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
            knownCommandsField.setAccessible(true);
            Map knownCommands = (Map)knownCommandsField.get(commandMap);
            knownCommands.remove("unknown");
            knownCommands.remove("minecraft:unknown");
            knownCommands.remove("bukkit:unknown");
            Command customFallback = new Command("unknown"){

                public boolean execute(CommandSender sender, String label, String[] args) {
                    sender.sendMessage(ServerInvalidCommandHandler.this.unknownCommandMessage);
                    return true;
                }
            };
            knownCommands.put("unknown", customFallback);
            knownCommands.put("minecraft:unknown", customFallback);
            knownCommands.put("bukkit:unknown", customFallback);
            Field fallbackField = SimpleCommandMap.class.getDeclaredField("fallbackCommand");
            fallbackField.setAccessible(true);
            fallbackField.set(commandMap, customFallback);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to override command system: " + e.getMessage());
        }
    }

    public void reload() {
        this.loadMessages();
    }
}

