/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Commands;

import dev.atrox.lightchat.HexColor;
import dev.atrox.lightchat.LightChat;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class WebsiteCommand
implements CommandExecutor {
    private final LightChat plugin;

    public WebsiteCommand(LightChat plugin) {
        this.plugin = plugin;
        plugin.getCommand("website").setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        FileConfiguration messagesConfig = this.plugin.getCustomConfig("messages.yml");
        String websiteLink = messagesConfig.getString("website-command.website-link", "https://yourwebsite.com");
        String websiteMessage = messagesConfig.getString("website-command.message", "&bVisit our website:\n&e%website-link%");
        String hoverText = HexColor.translateAlternateColorCodes('&', messagesConfig.getString("website-command.website-hover", "&eClick to visit our website!"));
        if (sender instanceof Player) {
            Player player = (Player)sender;
            TextComponent link = new TextComponent(HexColor.translateAlternateColorCodes('&', websiteLink));
            link.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, websiteLink));
            link.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)hoverText)));
            TextComponent message = new TextComponent(HexColor.translateAlternateColorCodes('&', websiteMessage.split("%website-link%")[0]));
            message.addExtra((BaseComponent)link);
            player.spigot().sendMessage((BaseComponent)message);
        } else {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', websiteMessage.replace("%website-link%", websiteLink)));
        }
        return true;
    }
}

