/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.platform;

import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.GameShuttingDownEvent;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;
import ru.vidtu.ias.IAS;
import ru.vidtu.ias.IASMinecraft;
import ru.vidtu.ias.screen.ConfigScreen;

@Mod(value="ias", dist={Dist.CLIENT})
@NullMarked
@ApiStatus.Internal
public final class INeoForge {
    private static final Logger LOGGER = LogManager.getLogger((String)"IAS/INeoForge");

    public INeoForge(Dist dist, ModContainer container, IEventBus bus) {
        assert (dist != null) : "HCsCR: Parameter 'dist' is null. (container: " + String.valueOf(container) + ", bus: " + String.valueOf(bus) + ", mod: " + String.valueOf(this) + ")";
        assert (container != null) : "HCsCR: Parameter 'container' is null. (dist: " + String.valueOf(dist) + ", bus: " + String.valueOf(bus) + ", mod: " + String.valueOf(this) + ")";
        assert (bus != null) : "HCsCR: Parameter 'bus' is null. (dist: " + String.valueOf(dist) + ", container: " + String.valueOf(container) + ", mod: " + String.valueOf(this) + ")";
        long start = System.nanoTime();
        LOGGER.info("IAS: Loading... (platform: neoforge)");
        if (dist != Dist.CLIENT) {
            throw new UnsupportedOperationException("IAS: You've tried to load the In-Game Account Switcher mod on a server. This won't work.");
        }
        NeoForge.EVENT_BUS.addListener(GameShuttingDownEvent.class, event -> IAS.close());
        NeoForge.EVENT_BUS.addListener(ScreenEvent.Init.Post.class, event -> {
            Screen screen = event.getScreen();
            IASMinecraft.onInit(screen.getMinecraft(), screen, arg_0 -> ((ScreenEvent.Init.Post)event).addListener(arg_0));
        });
        NeoForge.EVENT_BUS.addListener(ScreenEvent.Render.Post.class, event -> {
            Screen screen = event.getScreen();
            IASMinecraft.onDraw(screen, screen.getFont(), event.getGuiGraphics());
        });
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(modOrGame, parent) -> new ConfigScreen(parent)));
        String modVersion = ModList.get().getModContainerById("ias").map(ModContainer::getModInfo).map(IModInfo::getVersion).map(ArtifactVersion::toString).orElse("UNKNOWN");
        String loaderVersion = ModList.get().getModContainerById("neoforge").map(ModContainer::getModInfo).map(IModInfo::getVersion).map(ArtifactVersion::toString).orElse("UNKNOWN");
        IASMinecraft.init(FMLPaths.GAMEDIR.get(), FMLPaths.CONFIGDIR.get(), "NeoForge", modVersion, loaderVersion);
        LOGGER.info("IAS: Loaded. ({} ms)", (Object)((System.nanoTime() - start) / 1000000L));
    }

    @Contract(pure=true)
    public String toString() {
        return "IAS/INeoForge{}";
    }
}

