/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.screen;

import com.mojang.authlib.yggdrasil.ProfileResult;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.world.entity.player.PlayerSkin;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vidtu.ias.IAS;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.account.OfflineAccount;
import ru.vidtu.ias.auth.LoginData;
import ru.vidtu.ias.config.IASStorage;
import ru.vidtu.ias.screen.AccountEntry;
import ru.vidtu.ias.screen.AccountScreen;
import ru.vidtu.ias.screen.AddPopupScreen;
import ru.vidtu.ias.screen.DeletePopupScreen;
import ru.vidtu.ias.screen.LoginPopupScreen;

final class AccountList
extends ObjectSelectionList<AccountEntry> {
    private static final Map<UUID, PlayerSkin> SKINS = new WeakHashMap<UUID, PlayerSkin>(4);
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"IAS/AccountList");
    private final AccountScreen screen;

    AccountList(AccountScreen screen, Minecraft minecraft, int width, int height, int offset, int item) {
        super(minecraft, width, height, offset, item);
        this.screen = screen;
        this.update(this.screen.search().getValue());
    }

    public int getRowWidth() {
        return Math.min(super.getRowWidth(), this.screen.width - 190);
    }

    public void setSelected(@Nullable AccountEntry entry) {
        super.setSelected((AbstractSelectionList.Entry)entry);
        this.screen.updateSelected();
    }

    void update(String query) {
        if (query == null || query.isBlank()) {
            AccountEntry selected = (AccountEntry)this.getSelected();
            this.replaceEntries(IASStorage.ACCOUNTS.stream().map(account -> new AccountEntry(this.minecraft, this, (Account)account)).toList());
            this.setSelected(this.children().contains((Object)selected) ? selected : null);
            this.screen.updateSelected();
            return;
        }
        String lowerQuery = query.toLowerCase(Locale.ROOT);
        AccountEntry selected = (AccountEntry)this.getSelected();
        this.replaceEntries(IASStorage.ACCOUNTS.stream().filter(account -> account.name().toLowerCase(Locale.ROOT).contains(lowerQuery)).sorted((f, s) -> Boolean.compare(s.name().toLowerCase(Locale.ROOT).startsWith(lowerQuery), f.name().toLowerCase(Locale.ROOT).startsWith(lowerQuery))).map(account -> new AccountEntry(this.minecraft, this, (Account)account)).toList());
        this.setSelected(this.children().contains((Object)selected) ? selected : null);
        this.screen.updateSelected();
    }

    void login(boolean online) {
        AccountEntry selected = (AccountEntry)this.getSelected();
        if (selected == null) {
            return;
        }
        Account account = selected.account();
        if (online && account.canLogin()) {
            LoginPopupScreen login = new LoginPopupScreen(this.screen);
            this.minecraft.setScreen((Screen)login);
            IAS.executor().execute(() -> account.login(login));
            return;
        }
        LoginPopupScreen login = new LoginPopupScreen(this.screen);
        this.minecraft.setScreen((Screen)login);
        String name = account.name();
        LoginData data = new LoginData(name, OfflineAccount.uuid(name), "ias:offline", false);
        login.success(data, false);
    }

    void edit() {
        AccountEntry selected = (AccountEntry)this.getSelected();
        if (selected == null) {
            return;
        }
        int index = this.children().indexOf((Object)selected);
        if (index < 0 || index >= IASStorage.ACCOUNTS.size()) {
            return;
        }
        this.minecraft.setScreen((Screen)new AddPopupScreen(this.screen, true, account -> {
            this.minecraft.setScreen((Screen)this.screen);
            IASStorage.ACCOUNTS.removeIf(Predicate.isEqual(account));
            if (index >= IASStorage.ACCOUNTS.size()) {
                IASStorage.ACCOUNTS.add((Account)account);
            } else {
                IASStorage.ACCOUNTS.set(index, (Account)account);
            }
            try {
                IAS.disclaimersStorage();
                IAS.saveStorage();
            }
            catch (Throwable t) {
                LOGGER.error("IAS: Unable to save storage.", t);
            }
            this.update(this.screen.search().getValue());
        }));
    }

    void delete(boolean confirm) {
        AccountEntry selected = (AccountEntry)this.getSelected();
        if (selected == null) {
            return;
        }
        Account account = selected.account();
        if (!confirm) {
            IASStorage.ACCOUNTS.remove(account);
            try {
                IAS.disclaimersStorage();
                IAS.saveStorage();
            }
            catch (Throwable t) {
                LOGGER.error("IAS: Unable to save storage.", t);
            }
            this.update(this.screen.search().getValue());
            return;
        }
        this.minecraft.setScreen((Screen)new DeletePopupScreen(this.screen, account, () -> {
            IASStorage.ACCOUNTS.removeIf(Predicate.isEqual(account));
            try {
                IAS.disclaimersStorage();
                IAS.saveStorage();
            }
            catch (Throwable t) {
                LOGGER.error("IAS: Unable to save storage.", t);
            }
            this.update(this.screen.search().getValue());
        }));
    }

    void add() {
        this.minecraft.setScreen((Screen)new AddPopupScreen(this.screen, false, account -> {
            this.minecraft.setScreen((Screen)this.screen);
            IASStorage.ACCOUNTS.removeIf(Predicate.isEqual(account));
            IASStorage.ACCOUNTS.add((Account)account);
            try {
                IAS.disclaimersStorage();
                IAS.saveStorage();
            }
            catch (Throwable t) {
                LOGGER.error("IAS: Unable to save storage.", t);
            }
            this.update(this.screen.search().getValue());
        }));
    }

    PlayerSkin skin(AccountEntry entry) {
        UUID uuid = entry.account().skin();
        PlayerSkin skin = SKINS.get(uuid);
        if (skin != null) {
            return skin;
        }
        skin = DefaultPlayerSkin.get((UUID)uuid);
        SKINS.put(uuid, skin);
        if (uuid.version() != 4) {
            return skin;
        }
        ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            ProfileResult result = this.minecraft.services().sessionService().fetchProfile(uuid, false);
            if (result == null) {
                return null;
            }
            return result.profile();
        }, IAS.executor()).thenComposeAsync(profile -> {
            if (profile == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.minecraft.getSkinManager().get(profile);
        }, (Executor)IAS.executor())).thenAcceptAsync(loaded -> loaded.ifPresent(newSkin -> SKINS.put(uuid, (PlayerSkin)newSkin)), (Executor)this.minecraft)).exceptionally(t -> {
            LOGGER.warn("IAS: Unable to load skin: {}", (Object)entry, t);
            return null;
        });
        return skin;
    }

    void swapUp(AccountEntry entry) {
        int idx = this.children().indexOf((Object)entry);
        if (idx < 0 || idx >= IASStorage.ACCOUNTS.size()) {
            return;
        }
        int upIdx = idx - 1;
        if (upIdx < 0) {
            return;
        }
        IASStorage.ACCOUNTS.set(idx, IASStorage.ACCOUNTS.get(upIdx));
        IASStorage.ACCOUNTS.set(upIdx, entry.account());
        try {
            IAS.disclaimersStorage();
            IAS.saveStorage();
        }
        catch (Throwable t) {
            LOGGER.error("IAS: Unable to save storage.", t);
        }
        this.swap(idx, upIdx);
    }

    void swapDown(AccountEntry entry) {
        int idx = this.children().indexOf((Object)entry);
        if (idx < 0 || idx >= IASStorage.ACCOUNTS.size()) {
            return;
        }
        int downIdx = idx + 1;
        if (downIdx >= this.children().size() || downIdx >= IASStorage.ACCOUNTS.size()) {
            return;
        }
        IASStorage.ACCOUNTS.set(idx, IASStorage.ACCOUNTS.get(downIdx));
        IASStorage.ACCOUNTS.set(downIdx, entry.account());
        try {
            IAS.disclaimersStorage();
            IAS.saveStorage();
        }
        catch (Throwable t) {
            LOGGER.error("IAS: Unable to save storage.", t);
        }
        this.swap(idx, downIdx);
    }

    AccountScreen screen() {
        return this.screen;
    }

    public String toString() {
        return "AccountList{children=" + String.valueOf(this.children()) + "}";
    }
}

