/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.screen;

import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.joml.Matrix3x2fStack;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.screen.MicrosoftCryptPopupScreen;
import ru.vidtu.ias.screen.OfflinePopupScreen;
import ru.vidtu.ias.screen.PopupButton;

final class AddPopupScreen
extends Screen {
    private final Screen parent;
    private final Consumer<Account> handler;

    AddPopupScreen(Screen parent, boolean edit, Consumer<Account> handler) {
        super((Component)Component.translatable((String)(edit ? "ias.edit" : "ias.add")));
        this.parent = parent;
        this.handler = handler;
    }

    protected void init() {
        assert (this.minecraft != null);
        if (this.parent != null) {
            this.parent.init(this.minecraft, this.width, this.height);
        }
        PopupButton button = new PopupButton(this.width / 2 - 75, this.height / 2 - 24, 150, 20, (Component)Component.translatable((String)"ias.add.microsoft"), btn -> this.minecraft.setScreen((Screen)new MicrosoftCryptPopupScreen(this.parent, this.handler)), Supplier::get);
        button.setTooltip(Tooltip.create((Component)Component.translatable((String)"ias.add.microsoft.tip")));
        button.setTooltipDelay(Duration.ofMillis(250L));
        button.color(0.5f, 1.0f, 0.5f, true);
        this.addRenderableWidget((GuiEventListener)button);
        button = new PopupButton(this.width / 2 - 75, this.height / 2, 150, 20, (Component)Component.translatable((String)"ias.add.offline"), btn -> this.minecraft.setScreen((Screen)new OfflinePopupScreen(this.parent, this.handler)), Supplier::get);
        button.setTooltip(Tooltip.create((Component)Component.translatable((String)"ias.add.offline.tip")));
        button.setTooltipDelay(Duration.ofMillis(250L));
        button.color(1.0f, 0.5f, 0.5f, true);
        this.addRenderableWidget((GuiEventListener)button);
        this.addRenderableWidget((GuiEventListener)new PopupButton(this.width / 2 - 75, this.height / 2 + 49 - 22, 150, 20, CommonComponents.GUI_CANCEL, btn -> this.onClose(), Supplier::get));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        assert (this.minecraft != null);
        Matrix3x2fStack pose = graphics.pose();
        super.render(graphics, mouseX, mouseY, delta);
        pose.pushMatrix();
        pose.scale(2.0f, 2.0f);
        graphics.drawCenteredString(this.font, this.title, this.width / 4, this.height / 4 - 24, -1);
        pose.popMatrix();
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        assert (this.minecraft != null);
        if (this.parent != null) {
            this.parent.renderWithTooltipAndSubtitles(graphics, 0, 0, delta);
            graphics.nextStratum();
            graphics.fill(0, 0, this.width, this.height, Integer.MIN_VALUE);
        } else {
            super.renderBackground(graphics, mouseX, mouseY, delta);
        }
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        graphics.fill(centerX - 80, centerY - 50, centerX + 80, centerY + 50, -132112336);
        graphics.fill(centerX - 79, centerY - 51, centerX + 79, centerY - 50, -132112336);
        graphics.fill(centerX - 79, centerY + 50, centerX + 79, centerY + 51, -132112336);
    }

    public void onClose() {
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
    }

    public String toString() {
        return "AddPopupScreen{}";
    }
}

