/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.screen;

import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix3x2fStack;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vidtu.ias.IAS;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.account.MicrosoftAccount;
import ru.vidtu.ias.auth.handlers.CreateHandler;
import ru.vidtu.ias.auth.microsoft.MSAuthClient;
import ru.vidtu.ias.auth.microsoft.MSAuthServer;
import ru.vidtu.ias.config.IASConfig;
import ru.vidtu.ias.crypt.Crypt;
import ru.vidtu.ias.crypt.PasswordCrypt;
import ru.vidtu.ias.platform.IStonecutter;
import ru.vidtu.ias.screen.PopupBox;
import ru.vidtu.ias.screen.PopupButton;
import ru.vidtu.ias.utils.exceptions.FriendlyException;

final class MicrosoftPopupScreen
extends Screen
implements CreateHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"IAS/MicrosoftPopupScreen");
    private final Screen parent;
    private final Object lock = new Object();
    private final Consumer<Account> handler;
    private Crypt crypt;
    private MSAuthClient client;
    private MSAuthServer server;
    private Component stage = Component.translatable((String)"ias.login.initializing").withStyle(ChatFormatting.YELLOW);
    private MultiLineLabel label;
    private PopupBox password;
    private MultiLineLabel cryptPasswordTip;
    private float error = Float.NaN;
    private MultiLineLabel errorNote;

    MicrosoftPopupScreen(Screen parent, Consumer<Account> handler, Crypt crypt) {
        super((Component)Component.translatable((String)"ias.login"));
        this.parent = parent;
        this.handler = handler;
        this.crypt = crypt;
    }

    @Override
    public boolean cancelled() {
        assert (this.minecraft != null);
        return this != this.minecraft.screen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        assert (this.minecraft != null);
        Object object = this.lock;
        synchronized (object) {
            this.label = null;
        }
        if (this.parent != null) {
            this.parent.init(this.minecraft, this.width, this.height);
        }
        this.addRenderableWidget((GuiEventListener)new PopupButton(this.width / 2 - 75, this.height / 2 + 74 - 22, 150, 20, CommonComponents.GUI_BACK, btn -> this.onClose(), Supplier::get));
        if (this.crypt == null) {
            this.password = new PopupBox(this.font, this.width / 2 - 100, this.height / 2 - 10 + 5, 178, 20, this.password, (Component)Component.translatable((String)"ias.password"), () -> {
                if (this.password == null || this.crypt != null) {
                    return;
                }
                String value = this.password.getValue();
                if (value.isBlank()) {
                    return;
                }
                this.crypt = new PasswordCrypt(value);
                this.password = null;
                this.cryptPasswordTip = null;
                this.init(this.minecraft, this.width, this.height);
            }, true);
            this.password.setHint((Component)Component.translatable((String)"ias.password.hint").withStyle(ChatFormatting.DARK_GRAY));
            this.password.addFormatter((s, i) -> IASConfig.passwordEchoing ? FormattedCharSequence.forward((String)"*".repeat(s.length()), (Style)Style.EMPTY) : FormattedCharSequence.EMPTY);
            this.password.setMaxLength(32);
            this.addRenderableWidget((GuiEventListener)this.password);
            PopupButton enterPassword = new PopupButton(this.width / 2 - 100 + 180, this.height / 2 - 10 + 5, 20, 20, (Component)Component.literal((String)">>"), btn -> {
                if (this.password == null || this.crypt != null) {
                    return;
                }
                String value = this.password.getValue();
                if (value.isBlank()) {
                    return;
                }
                this.crypt = new PasswordCrypt(value);
                this.password = null;
                this.cryptPasswordTip = null;
                this.init(this.minecraft, this.width, this.height);
            }, Supplier::get);
            enterPassword.active = !this.password.getValue().isBlank();
            this.addRenderableWidget((GuiEventListener)enterPassword);
            this.password.setResponder(value -> {
                enterPassword.active = !value.isBlank();
            });
            this.cryptPasswordTip = MultiLineLabel.create((Font)this.font, (Component)Component.translatable((String)"ias.password.tip"), (int)320);
        }
        IAS.executor().execute(() -> {
            if (IASConfig.useServerAuth()) {
                this.server();
            } else {
                this.client();
            }
        });
    }

    private void client() {
        try {
            assert (this.minecraft != null);
            if (this.crypt == null || this.server != null || this.client != null) {
                return;
            }
            this.client = new MSAuthClient(this.crypt, this);
            ((CompletableFuture)this.client.start().thenAcceptAsync(auth -> {
                LOGGER.info("IAS: Opening client link...");
                this.stage("ias.login.linkClient", Component.literal((String)auth.uri().toString()).withStyle(ChatFormatting.GOLD), Component.literal((String)auth.user()).withStyle(ChatFormatting.GOLD));
                IStonecutter.openUrl(auth.uri().toString());
                this.minecraft.keyboardHandler.setClipboard(auth.user());
            }, (Executor)this.minecraft)).exceptionally(t -> {
                this.error(new RuntimeException("Unable to handle client.", (Throwable)t));
                return null;
            });
        }
        catch (Throwable t2) {
            this.error(new RuntimeException("Unable to create client.", t2));
        }
    }

    private void server() {
        try {
            assert (this.minecraft != null);
            if (this.crypt == null || this.server != null || this.client != null) {
                return;
            }
            this.server = new MSAuthServer(I18n.get((String)"ias.login.done", (Object[])new Object[0]), this.crypt, this);
            ((CompletableFuture)CompletableFuture.runAsync(() -> this.server.run(), IAS.executor()).thenRunAsync(() -> {
                LOGGER.info("IAS: Opening server link...");
                this.stage("ias.login.link", new Object[0]);
                String url = this.server.authUrl();
                IStonecutter.openUrl(url);
                this.minecraft.keyboardHandler.setClipboard(url);
            }, (Executor)this.minecraft)).exceptionally(t -> {
                this.error(new RuntimeException("Unable to handle server.", (Throwable)t));
                return null;
            });
        }
        catch (Throwable t2) {
            this.error(new RuntimeException("Unable to create server.", t2));
        }
    }

    public void onClose() {
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
    }

    public void removed() {
        assert (this.minecraft != null);
        KeyboardHandler keyboard = this.minecraft.keyboardHandler;
        String clipboard = keyboard.getClipboard();
        if (clipboard.toLowerCase(Locale.ROOT).contains("54fd49e4-2103-4044-9603-2b028c814ec3".toLowerCase(Locale.ROOT))) {
            keyboard.setClipboard(" ");
        }
        IAS.executor().execute(() -> {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
            if (this.server != null) {
                this.server.close();
                this.server = null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        assert (this.minecraft != null);
        Matrix3x2fStack pose = graphics.pose();
        super.render(graphics, mouseX, mouseY, delta);
        pose.pushMatrix();
        pose.scale(2.0f, 2.0f);
        graphics.drawCenteredString(this.font, this.title, this.width / 4, this.height / 4 - 37, -1);
        pose.popMatrix();
        if (this.crypt == null && this.password != null && this.cryptPasswordTip != null) {
            graphics.drawCenteredString(this.font, this.password.getMessage(), this.width / 2, this.height / 2 - 10 - 5, -1);
            pose.pushMatrix();
            pose.scale(0.5f, 0.5f);
            IStonecutter.renderMultilineLabelCentered(this.cryptPasswordTip, graphics, this.width, this.height + 40);
            pose.popMatrix();
        } else {
            Object object = this.lock;
            synchronized (object) {
                if (this.label == null) {
                    Component component = (Component)Objects.requireNonNullElse(this.stage, Component.empty());
                    this.label = MultiLineLabel.create((Font)this.font, (Component)component, (int)240);
                    this.minecraft.getNarrator().saySystemQueued(component);
                }
                IStonecutter.renderMultilineLabelCentered(this.label, graphics, this.width / 2, (this.height - this.label.getLineCount() * 9) / 2 - 4);
            }
            if (Float.isFinite(this.error)) {
                int opacityMask;
                if (this.errorNote == null) {
                    this.errorNote = MultiLineLabel.create((Font)this.font, (Component)Component.translatable((String)"ias.error.note").withStyle(ChatFormatting.AQUA), (int)245);
                }
                if (this.error < 1.0f) {
                    this.error = Math.min(this.error + delta * 0.1f, 1.0f);
                    float opacityFloat = this.error * this.error * this.error * this.error;
                    int opacity = Math.max(9, (int)(opacityFloat * 255.0f));
                    opacityMask = opacity << 24;
                } else {
                    float opacityFloat = 1.0f;
                    opacityMask = -16777216;
                }
                int w = this.errorNote.getWidth() / 4 + 2;
                int h = this.errorNote.getLineCount() * 9 / 2 + 1;
                int cx = this.width / 2;
                int sy = this.height / 2 + 87;
                graphics.fill(cx - w, sy, cx + w, sy + h, 0x101010 | opacityMask);
                graphics.fill(cx - w + 1, sy - 1, cx + w - 1, sy, 0x101010 | opacityMask);
                graphics.fill(cx - w + 1, sy + h, cx + w - 1, sy + h + 1, 0x101010 | opacityMask);
                pose.pushMatrix();
                pose.scale(0.5f, 0.5f);
                this.errorNote.render(graphics, MultiLineLabel.Align.CENTER, this.width, this.height + 174, 9, false, 0xFFFFFF | opacityMask);
                pose.popMatrix();
            }
        }
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        assert (this.minecraft != null);
        if (this.parent != null) {
            this.parent.renderWithTooltipAndSubtitles(graphics, 0, 0, delta);
            graphics.nextStratum();
            graphics.fill(0, 0, this.width, this.height, Integer.MIN_VALUE);
        } else {
            super.renderBackground(graphics, mouseX, mouseY, delta);
        }
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        graphics.fill(centerX - 125, centerY - 75, centerX + 125, centerY + 75, -132112336);
        graphics.fill(centerX - 124, centerY - 76, centerX + 124, centerY - 75, -132112336);
        graphics.fill(centerX - 124, centerY + 75, centerX + 124, centerY + 76, -132112336);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stage(String stage, Object ... args) {
        assert (this.minecraft != null);
        if (this != this.minecraft.screen) {
            return;
        }
        if ("ias.login.processing".equals(stage)) {
            this.minecraft.execute(() -> {
                try {
                    long ptr = this.minecraft.getWindow().handle();
                    GLFW.glfwRequestWindowAttention((long)ptr);
                    GLFW.glfwFocusWindow((long)ptr);
                    GLFW.glfwRequestWindowAttention((long)ptr);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
        MutableComponent component = Component.translatable((String)stage, (Object[])args).withStyle(ChatFormatting.YELLOW);
        Object object = this.lock;
        synchronized (object) {
            this.stage = component;
            this.label = null;
        }
    }

    @Override
    public void success(MicrosoftAccount account) {
        assert (this.minecraft != null);
        if (this != this.minecraft.screen) {
            return;
        }
        this.stage("ias.login.finalizing", new Object[0]);
        this.minecraft.execute(() -> {
            if (this != this.minecraft.screen) {
                return;
            }
            this.handler.accept(account);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void error(Throwable error) {
        assert (this.minecraft != null);
        LOGGER.error("IAS: Create error.", error);
        if (this != this.minecraft.screen) {
            return;
        }
        FriendlyException probable = FriendlyException.friendlyInChain(error);
        String key = probable != null ? probable.key() : "ias.error";
        MutableComponent component = Component.translatable((String)key).withStyle(ChatFormatting.RED);
        Object object = this.lock;
        synchronized (object) {
            this.stage = component;
            this.label = null;
            this.error = 0.0f;
        }
    }

    public String toString() {
        return "MicrosoftPopupScreen{crypt=" + String.valueOf(this.crypt) + ", client=" + String.valueOf(this.client) + ", server=" + String.valueOf(this.server) + ", stage=" + String.valueOf(this.stage) + ", label=" + String.valueOf(this.label) + "}";
    }
}

