/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias;

import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.File;
import java.net.Proxy;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.social.PlayerSocialManager;
import net.minecraft.client.multiplayer.ProfileKeyPairManager;
import net.minecraft.client.multiplayer.chat.report.ReportEnvironment;
import net.minecraft.client.multiplayer.chat.report.ReportingContext;
import net.minecraft.client.telemetry.ClientTelemetryManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.server.Services;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vidtu.ias.IAS;
import ru.vidtu.ias.auth.LoginData;
import ru.vidtu.ias.config.IASConfig;
import ru.vidtu.ias.mixins.MinecraftAccessor;
import ru.vidtu.ias.platform.IStonecutter;
import ru.vidtu.ias.screen.AccountScreen;
import ru.vidtu.ias.utils.Expression;
import ru.vidtu.ias.utils.IUtils;
import ru.vidtu.ias.utils.exceptions.FriendlyException;

public final class IASMinecraft {
    public static final SystemToast.SystemToastId NICK_WARN = new SystemToast.SystemToastId(10000L);
    public static final WidgetSprites BUTTON = new WidgetSprites(IStonecutter.identifier("button_plain"), IStonecutter.identifier("button_disabled"), IStonecutter.identifier("button_focus"));
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"IAS/IASMinecraft");
    private static int textX;
    private static int textY;
    private static Component text;

    private IASMinecraft() {
        throw new AssertionError((Object)"No instances.");
    }

    public static void init(Path gameDir, Path configDir, String loader, String modVersion, String loaderVersion) {
        String gameVersion = SharedConstants.getCurrentVersion().name();
        LOGGER.info("IAS: Booting up... (version: {}, loader: {}, loader version: {}, game version: {})", new Object[]{modVersion, loader, loaderVersion, gameVersion});
        IAS.init(gameDir, configDir, modVersion, loader, loaderVersion, gameVersion);
    }

    public static void onInit(Minecraft minecraft, Screen screen, Consumer<Button> buttonAdder) {
        Font font;
        Integer cy;
        Integer cx;
        int height;
        int width;
        if (IASConfig.titleButton && screen instanceof TitleScreen) {
            width = screen.width;
            height = screen.height;
            Integer x = Expression.parsePosition(IASConfig.titleButtonX, width, height);
            Integer y = Expression.parsePosition(IASConfig.titleButtonY, width, height);
            if (x == null || y == null) {
                x = width / 2 + 104;
                y = height / 4 + 72;
                for (int i = 0; i < 64; ++i) {
                    boolean overlapping = false;
                    for (GuiEventListener child : screen.children()) {
                        if (!(child instanceof LayoutElement)) continue;
                        LayoutElement le = (LayoutElement)child;
                        if (child instanceof AbstractSelectionList) continue;
                        int x1 = le.getX() - 4;
                        int y1 = le.getY() - 4;
                        int x2 = x1 + le.getWidth() + 8;
                        int y2 = y1 + le.getHeight() + 8;
                        if (x < x1 || y < y1 || x + 20 > x2 || y + 20 > y2) continue;
                        x = Math.max(x, x2);
                        overlapping = true;
                    }
                    if (!overlapping) break;
                }
            }
            ImageButton button = new ImageButton(x.intValue(), y.intValue(), 20, 20, BUTTON, btn -> minecraft.setScreen((Screen)new AccountScreen(screen)), (Component)Component.literal((String)"In-Game Account Switcher"));
            button.setTooltip(Tooltip.create((Component)button.getMessage()));
            button.setTooltipDelay(Duration.ofMillis(250L));
            buttonAdder.accept((Button)button);
        }
        if (IASConfig.titleText && screen instanceof TitleScreen) {
            int n;
            width = screen.width;
            height = screen.height;
            cx = Expression.parsePosition(IASConfig.titleTextX, width, height);
            cy = Expression.parsePosition(IASConfig.titleTextY, width, height);
            font = minecraft.font;
            User user = minecraft.getUser();
            text = Component.translatable((String)"ias.title", (Object[])new Object[]{user != null ? user.getName() : "(broken by mods)"});
            if (cx == null || cy == null) {
                n = (width - font.width((FormattedText)text)) / 2;
            } else {
                switch (IASConfig.titleTextAlign) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case LEFT: {
                        n = cx;
                        break;
                    }
                    case CENTER: {
                        n = cx - font.width((FormattedText)text) / 2;
                        break;
                    }
                    case RIGHT: {
                        n = cx - font.width((FormattedText)text);
                    }
                }
            }
            textX = n;
            int n2 = textY = cx == null || cy == null ? height / 4 + 164 : cy;
        }
        if (IASConfig.serversText && screen instanceof JoinMultiplayerScreen) {
            int n;
            width = screen.width;
            height = screen.height;
            cx = Expression.parsePosition(IASConfig.serversTextX, width, height);
            cy = Expression.parsePosition(IASConfig.serversTextY, width, height);
            font = minecraft.font;
            User user = minecraft.getUser();
            text = Component.translatable((String)"ias.title", (Object[])new Object[]{user != null ? user.getName() : "(broken by mods)"});
            if (cx == null || cy == null) {
                n = (width - font.width((FormattedText)text)) / 2;
            } else {
                switch (IASConfig.serversTextAlign) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case LEFT: {
                        n = cx;
                        break;
                    }
                    case CENTER: {
                        n = cx - font.width((FormattedText)text) / 2;
                        break;
                    }
                    case RIGHT: {
                        n = cx - font.width((FormattedText)text);
                    }
                }
            }
            textX = n;
            int n3 = textY = cx == null || cy == null ? 5 : cy;
        }
        if (!IASConfig.nickWarns || !(screen instanceof ConnectScreen) || minecraft.getToastManager().getToast(SystemToast.class, (Object)NICK_WARN) != null) {
            return;
        }
        User user = minecraft.getUser();
        String name = user != null ? user.getName() : "";
        String key = IUtils.warnKey(name);
        if (key == null) {
            return;
        }
        ToastManager manager = minecraft.getToastManager();
        manager.addToast((Toast)SystemToast.multiline((Minecraft)minecraft, (SystemToast.SystemToastId)NICK_WARN, (Component)Component.literal((String)"In-Game Account Switcher"), (Component)Component.translatable((String)key, (Object[])new Object[]{name})));
    }

    public static void onDraw(Screen screen, Font font, GuiGraphics graphics) {
        if (IASConfig.titleText && screen instanceof TitleScreen) {
            graphics.drawString(font, text, textX, textY, -3372920);
        }
        if (IASConfig.serversText && screen instanceof JoinMultiplayerScreen) {
            graphics.drawString(font, text, textX, textY, -3372920);
        }
    }

    public static CompletableFuture<Void> account(Minecraft minecraft, LoginData data) {
        LOGGER.info("IAS: Received login request: {}", (Object)data);
        if (minecraft.player != null || minecraft.level != null || minecraft.getConnection() != null || minecraft.getCameraEntity() != null || minecraft.gameMode != null || minecraft.isSingleplayer()) {
            return CompletableFuture.failedFuture(new FriendlyException("Changing accounts in world.", "ias.error.world"));
        }
        return CompletableFuture.runAsync(() -> {
            UserApiService.UserProperties properties;
            LOGGER.info("IAS: Creating user...");
            boolean online = data.online();
            User user = new User(data.name(), data.uuid(), data.token(), Optional.empty(), Optional.empty());
            YggdrasilAuthenticationService service = online ? new YggdrasilAuthenticationService(minecraft.getProxy()) : YggdrasilAuthenticationService.createOffline((Proxy)minecraft.getProxy());
            Services services = Services.create((YggdrasilAuthenticationService)service, (File)minecraft.gameDirectory);
            CompletableFuture<Object> profile = CompletableFuture.completedFuture(online ? services.sessionService().fetchProfile(data.uuid(), true) : null);
            MinecraftAccessor accessor = (MinecraftAccessor)minecraft;
            UserApiService apiService = online ? service.createUserApiService(data.token()) : UserApiService.OFFLINE;
            try {
                properties = apiService.fetchProperties();
            }
            catch (Throwable ignored) {
                properties = UserApiService.OFFLINE_PROPERTIES;
            }
            CompletableFuture<UserApiService.UserProperties> propertiesFuture = CompletableFuture.completedFuture(properties);
            PlayerSocialManager social = new PlayerSocialManager(minecraft, apiService);
            ClientTelemetryManager telemetry = new ClientTelemetryManager(minecraft, apiService, user);
            ProfileKeyPairManager keyPair = ProfileKeyPairManager.create((UserApiService)apiService, (User)user, (Path)minecraft.gameDirectory.toPath());
            ReportingContext reporting = ReportingContext.create((ReportEnvironment)ReportEnvironment.local(), (UserApiService)apiService);
            minecraft.execute(() -> {
                LOGGER.info("IAS: Flushing user...");
                accessor.ias$services(services);
                accessor.ias$user(user);
                accessor.ias$profileFuture(profile);
                accessor.ias$userApiService(apiService);
                accessor.ias$userPropertiesFuture(propertiesFuture);
                accessor.ias$playerSocialManager(social);
                accessor.ias$telemetryManager(telemetry);
                accessor.ias$profileKeyPairManager(keyPair);
                accessor.ias$reportingContext(reporting);
                minecraft.updateTitle();
                LOGGER.info("IAS: Flushed user.");
            });
        }, IAS.executor()).exceptionally(t -> {
            LOGGER.error("IAS: Unable to log in: {}.", (Object)data, t);
            throw new RuntimeException("Unable to change account to: " + String.valueOf(data), (Throwable)t);
        });
    }

    static {
        text = Component.translatable((String)"ias.title", (Object[])new Object[]{"(not loaded for some reason)"});
    }
}

