/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.platform;

import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.GameShuttingDownEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;
import ru.vidtu.ias.IAS;
import ru.vidtu.ias.IASMinecraft;
import ru.vidtu.ias.screen.ConfigScreen;

@Mod(value="ias")
@NullMarked
@ApiStatus.Internal
public final class IForge {
    private static final Logger LOGGER = LogManager.getLogger((String)"IAS/IForge");

    public IForge(FMLJavaModLoadingContext ctx) {
        assert (ctx != null) : "IAS: Parameter 'ctx' is null. (mod: " + String.valueOf(this) + ")";
        long start = System.nanoTime();
        LOGGER.info("IAS: Loading... (platform: forge)");
        if (FMLEnvironment.dist != Dist.CLIENT) {
            throw new UnsupportedOperationException("IAS: You've tried to load the In-Game Account Switcher mod on a server. This won't work.");
        }
        GameShuttingDownEvent.BUS.addListener(event -> IAS.close());
        ScreenEvent.Init.Post.BUS.addListener(event -> {
            Screen screen = event.getScreen();
            IASMinecraft.onInit(screen.getMinecraft(), screen, arg_0 -> ((ScreenEvent.Init.Post)event).addListener(arg_0));
        });
        ScreenEvent.Render.Post.BUS.addListener(event -> {
            Screen screen = event.getScreen();
            IASMinecraft.onDraw(screen, screen.getFont(), event.getGuiGraphics());
        });
        ctx.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory(ConfigScreen::new));
        ctx.registerDisplayTest(IExtensionPoint.DisplayTest.IGNORE_SERVER_VERSION);
        String modVersion = ModList.get().getModContainerById("ias").map(ModContainer::getModInfo).map(IModInfo::getVersion).map(ArtifactVersion::toString).orElse("UNKNOWN");
        String loaderVersion = ModList.get().getModContainerById("forge").map(ModContainer::getModInfo).map(IModInfo::getVersion).map(ArtifactVersion::toString).orElse("UNKNOWN");
        IASMinecraft.init(FMLPaths.GAMEDIR.get(), FMLPaths.CONFIGDIR.get(), "Forge", modVersion, loaderVersion);
        LOGGER.info("IAS: Loaded. ({} ms)", (Object)((System.nanoTime() - start) / 1000000L));
    }

    @Contract(pure=true)
    public String toString() {
        return "IAS/IForge{}";
    }
}

