/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.screen;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.PlayerSkin;
import org.jetbrains.annotations.NotNull;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.platform.IStonecutter;
import ru.vidtu.ias.screen.AccountList;

final class AccountEntry
extends ObjectSelectionList.Entry<AccountEntry> {
    private static final WidgetSprites UP = new WidgetSprites(IStonecutter.identifier("up_plain"), IStonecutter.identifier("up_disabled"), IStonecutter.identifier("up_focus"));
    private static final WidgetSprites DOWN = new WidgetSprites(IStonecutter.identifier("down_plain"), IStonecutter.identifier("down_disabled"), IStonecutter.identifier("down_focus"));
    private static final WidgetSprites WARNING = new WidgetSprites(IStonecutter.identifier("warning_off"), IStonecutter.identifier("warning_on"));
    private final Minecraft minecraft;
    private final AccountList list;
    private final Account account;
    private final List<FormattedCharSequence> tooltip;
    private long clicked = IStonecutter.internalMillisClock();
    private long lastFree = System.nanoTime();

    AccountEntry(Minecraft minecraft, AccountList list, Account account) {
        this.minecraft = minecraft;
        this.list = list;
        this.account = account;
        this.tooltip = Stream.of(CommonComponents.optionNameValue((Component)Component.translatable((String)"ias.accounts.tip.nick"), (Component)Component.literal((String)this.account.name())), CommonComponents.optionNameValue((Component)Component.translatable((String)"ias.accounts.tip.uuid"), (Component)Component.literal((String)this.account.uuid().toString())), CommonComponents.optionNameValue((Component)Component.translatable((String)"ias.accounts.tip.type"), (Component)Component.translatable((String)this.account.typeTipKey()))).map(Component::getVisualOrderText).toList();
    }

    public void renderContent(GuiGraphics graphics, int mouseX, int mouseY, boolean hovered, float delta) {
        if (hovered) {
            if (System.nanoTime() - this.lastFree >= 500000000L) {
                graphics.setTooltipForNextFrame(this.tooltip, mouseX, mouseY);
            }
        } else {
            this.lastFree = System.nanoTime();
        }
        PlayerSkin skin = this.list.skin(this);
        int x = this.getContentX();
        int y = this.getContentY();
        int width = this.getContentWidth();
        int height = this.getContentHeight();
        PlayerFaceRenderer.draw((GuiGraphics)graphics, (PlayerSkin)skin, (int)x, (int)y, (int)8);
        User user = this.minecraft.getUser();
        int color = user == null || !this.account.name().equalsIgnoreCase(user.getName()) ? -1 : (this.account.uuid().equals(user.getProfileId()) ? -16711936 : (this.account.name().equals(user.getName()) ? -256 : Short.MIN_VALUE));
        graphics.drawString(this.minecraft.font, this.account.name(), x + 10, y, color);
        if (this.account.insecure()) {
            boolean warning = System.nanoTime() / 1000000000L % 2L == 0L;
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, warning ? WARNING.enabled() : WARNING.enabledFocused(), x - 6, y - 1, 2, 10);
            if (mouseX >= x - 10 && mouseX <= x && mouseY >= y && mouseY <= y + height) {
                graphics.setTooltipForNextFrame((Component)Component.translatable((String)"ias.accounts.tip.insecure"), mouseX, mouseY);
            }
        }
        if (this.equals(this.list.getFocused()) || this.equals(this.list.getSelected())) {
            int upX = x + width - 28;
            ResourceLocation upTexture = this == this.list.children().getFirst() ? UP.disabled() : (mouseX >= upX && mouseY >= y && mouseX <= upX + 11 && mouseY <= y + height ? UP.enabledFocused() : UP.enabled());
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, upTexture, upX, y, 11, 7);
            int downX = x + width - 15;
            ResourceLocation downTexture = this == this.list.children().getLast() ? DOWN.disabled() : (mouseX >= downX && mouseY >= y && mouseX <= downX + 11 && mouseY <= y + height ? DOWN.enabledFocused() : DOWN.enabled());
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, downTexture, downX, y, 11, 7);
        }
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        double mouseX = event.x();
        if (this.equals(this.list.getFocused()) || this.equals(this.list.getSelected())) {
            int right = this.list.getRowRight();
            int upX = right - 28;
            if (mouseX >= (double)upX && mouseX <= (double)(upX + 11)) {
                this.list.swapUp(this);
                return true;
            }
            int downX = right - 15;
            if (mouseX >= (double)downX && mouseX <= (double)(downX + 11)) {
                this.list.swapDown(this);
                return true;
            }
        }
        if (IStonecutter.internalMillisClock() - this.clicked < 250L) {
            this.list.login(!event.hasShiftDown());
        }
        this.clicked = IStonecutter.internalMillisClock();
        return true;
    }

    @NotNull
    public Component getNarration() {
        return Component.literal((String)this.account.name());
    }

    Account account() {
        return this.account;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AccountEntry)) {
            return false;
        }
        AccountEntry that = (AccountEntry)((Object)obj);
        return Objects.equals(this.account, that.account);
    }

    public int hashCode() {
        return Objects.hashCode(this.account);
    }

    public String toString() {
        return "AccountEntry{account=" + String.valueOf(this.account) + "}";
    }
}

