/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.screen;

import java.time.Duration;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.PlayerSkinWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vidtu.ias.IAS;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.config.IASStorage;
import ru.vidtu.ias.platform.IStonecutter;
import ru.vidtu.ias.screen.AccountEntry;
import ru.vidtu.ias.screen.AccountList;

public final class AccountScreen
extends Screen {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"IAS/AccountScreen");
    private final Screen parent;
    private EditBox search;
    private AccountList list;
    private PlayerSkinWidget skin;
    private Button login;
    private Button offlineLogin;
    private Button edit;
    private Button delete;

    public AccountScreen(Screen parent) {
        super((Component)Component.translatable((String)"ias.accounts"));
        this.parent = parent;
    }

    protected void init() {
        assert (this.minecraft != null);
        if (IAS.disabled()) {
            this.minecraft.setScreen((Screen)new AlertScreen(this::onClose, (Component)Component.translatable((String)"ias.disabled.title").withStyle(ChatFormatting.RED), (Component)Component.translatable((String)"ias.disabled.text"), CommonComponents.GUI_BACK, true));
            return;
        }
        if (!IASStorage.gameDisclaimerShown) {
            this.minecraft.setScreen((Screen)new AlertScreen(() -> {
                try {
                    IAS.gameDisclaimerShownStorage();
                }
                catch (Throwable t) {
                    LOGGER.error("Unable to set or write game disclaimer state.", t);
                }
                this.minecraft.setScreen((Screen)this);
            }, (Component)Component.translatable((String)"ias.disclaimer.title").withStyle(ChatFormatting.YELLOW), (Component)Component.translatable((String)"ias.disclaimer.text"), CommonComponents.GUI_CONTINUE, false));
            return;
        }
        this.search = new EditBox(this.font, this.width / 2 - 75, 11, 150, 20, this.search, (Component)Component.translatable((String)"ias.accounts.search"));
        this.search.setHint((Component)this.search.getMessage().copy().withStyle(ChatFormatting.DARK_GRAY));
        this.addRenderableWidget((GuiEventListener)this.search);
        if (this.skin == null) {
            this.skin = new PlayerSkinWidget(85, 120, this.minecraft.getEntityModels(), () -> {
                if (this.list == null) {
                    return DefaultPlayerSkin.get((UUID)IStonecutter.NIL_UUID);
                }
                AccountEntry selected = (AccountEntry)this.list.getSelected();
                if (selected == null) {
                    return DefaultPlayerSkin.get((UUID)IStonecutter.NIL_UUID);
                }
                return this.list.skin(selected);
            });
        }
        this.skin.setPosition(5, this.height / 2 - 60);
        this.addRenderableWidget((GuiEventListener)this.skin);
        this.login = Button.builder((Component)Component.translatable((String)"ias.accounts.login"), btn -> this.list.login(true)).bounds(this.width / 2 - 50 - 100 - 4, this.height - 24 - 24, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.login);
        this.offlineLogin = Button.builder((Component)Component.translatable((String)"ias.accounts.offlineLogin"), btn -> this.list.login(false)).bounds(this.width / 2 - 50 - 100 - 4, this.height - 24, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.offlineLogin);
        this.edit = Button.builder((Component)Component.translatable((String)"ias.accounts.edit"), btn -> this.list.edit()).bounds(this.width / 2 - 50, this.height - 24 - 24, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.edit);
        this.delete = Button.builder((Component)Component.translatable((String)"ias.accounts.delete"), btn -> this.list.delete(!this.minecraft.hasShiftDown())).bounds(this.width / 2 - 50, this.height - 24, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.delete);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"ias.accounts.add"), btn -> this.list.add()).bounds(this.width / 2 + 50 + 4, this.height - 24 - 24, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_BACK, btn -> this.minecraft.setScreen(this.parent)).bounds(this.width / 2 + 50 + 4, this.height - 24, 100, 20).build());
        if (this.list != null) {
            this.list.setRectangle(this.width, this.height - 24 - 24 - 4 - 34, 0, 34);
        } else {
            this.list = new AccountList(this, this.minecraft, this.width, this.height - 24 - 24 - 4 - 34, 34, 12);
        }
        this.addRenderableWidget((GuiEventListener)this.list);
        this.search.setResponder(this.list::update);
        this.list.update(this.search.getValue());
        this.updateSelected();
    }

    public void onClose() {
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 1, -1);
    }

    EditBox search() {
        return this.search;
    }

    void updateSelected() {
        AccountEntry selected;
        AccountEntry accountEntry = selected = this.list != null ? (AccountEntry)this.list.getSelected() : null;
        if (selected == null) {
            this.delete.active = false;
            this.edit.active = false;
            this.offlineLogin.active = false;
            this.login.active = false;
            this.login.setTooltip(null);
            this.skin.visible = false;
            return;
        }
        this.delete.active = true;
        this.edit.active = true;
        this.offlineLogin.active = true;
        if (selected.account().canLogin()) {
            this.login.active = true;
            this.login.setTooltip(null);
        } else {
            this.login.active = false;
            this.login.setTooltip(Tooltip.create((Component)Component.translatable((String)"ias.accounts.login.offline")));
            this.login.setTooltipDelay(Duration.ZERO);
        }
        this.skin.visible = true;
    }

    public boolean keyPressed(KeyEvent event) {
        AccountEntry selected;
        int key = event.key();
        boolean shift = event.hasShiftDown();
        boolean control = event.hasControlDown();
        boolean select = event.isSelection();
        assert (this.minecraft != null);
        if (key == 264 && shift || key == 267) {
            this.list.swapDown((AccountEntry)this.list.getSelected());
            return true;
        }
        if (key == 265 && shift || key == 266) {
            this.list.swapUp((AccountEntry)this.list.getSelected());
            return true;
        }
        if (key == 67 && control && (selected = (AccountEntry)this.list.getSelected()) != null) {
            Account account = selected.account();
            this.minecraft.keyboardHandler.setClipboard(shift ? account.uuid().toString() : account.name());
            return true;
        }
        if (super.keyPressed(event)) {
            return true;
        }
        if (select) {
            this.list.login(!shift);
            return true;
        }
        if (key == 261 || key == 333) {
            this.list.delete(!shift);
            return true;
        }
        if (key == 78 && control || key == 334) {
            this.list.add();
            return true;
        }
        if (key == 82 && control || key == 332) {
            this.list.edit();
            return true;
        }
        return false;
    }

    public String toString() {
        return "AccountScreen{list=" + String.valueOf((Object)this.list) + "}";
    }
}

