/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.screen;

import java.time.Duration;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vidtu.ias.IAS;
import ru.vidtu.ias.config.IASConfig;
import ru.vidtu.ias.config.ServerMode;
import ru.vidtu.ias.config.TextAlign;
import ru.vidtu.ias.utils.Expression;

public final class ConfigScreen
extends Screen {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"IAS/ConfigScreen");
    private final Screen parent;
    private EditBox titleTextX;
    private EditBox titleTextY;
    private Button titleTextAlign;
    private EditBox titleButtonX;
    private EditBox titleButtonY;
    private EditBox serversTextX;
    private EditBox serversTextY;
    private Button serversTextAlign;
    private EditBox serversButtonX;
    private EditBox serversButtonY;

    public ConfigScreen(Screen parent) {
        super((Component)Component.translatable((String)"ias.config"));
        this.parent = parent;
    }

    protected void init() {
        assert (this.minecraft != null);
        if (IAS.disabled()) {
            this.minecraft.setScreen((Screen)new AlertScreen(this::onClose, (Component)Component.translatable((String)"ias.disabled.title").withStyle(ChatFormatting.RED), (Component)Component.translatable((String)"ias.disabled.text"), CommonComponents.GUI_BACK, true));
            return;
        }
        Checkbox box = Checkbox.builder((Component)Component.translatable((String)"ias.config.titleText"), (Font)this.font).pos(5, 20).selected(IASConfig.titleText).onValueChange((cb, value) -> {
            IASConfig.titleText = value;
            this.titleTextX.active = value;
            this.titleTextY.active = value;
            this.titleTextX.setEditable(value);
            this.titleTextY.setEditable(value);
            this.titleTextAlign.active = value;
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"ias.config.titleText.tip"))).build();
        box.setTooltipDelay(Duration.ofMillis(250L));
        this.addRenderableWidget((GuiEventListener)box);
        this.titleTextX = new EditBox(this.font, 9 + box.getWidth(), 20, 75, 20, this.titleTextX, (Component)Component.translatable((String)"ias.config.titleText.x"));
        this.titleTextX.setHint((Component)this.titleTextX.getMessage().copy().withStyle(ChatFormatting.DARK_GRAY));
        this.titleTextX.setTooltip(Tooltip.create((Component)Component.translatable((String)"ias.config.titleText.x.tip", (Object[])new Object[]{Component.translatable((String)"key.keyboard.left.alt")})));
        this.titleTextX.setTooltipDelay(Duration.ofMillis(250L));
        this.titleTextX.active = box.selected();
        this.titleTextX.setEditable(box.selected());
        this.titleTextX.setMaxLength(128);
        this.titleTextX.setResponder(value -> {
            IASConfig.titleTextX = value = value.isBlank() ? null : Expression.SPACE_PATTERN.matcher(value.strip()).replaceAll(" ");
            this.titleTextX.setTextColor(Expression.positionValidityColor(value, this.width, this.height, true));
        });
        this.titleTextX.setValue(Objects.requireNonNullElse(IASConfig.titleTextX, ""));
        this.addRenderableWidget((GuiEventListener)this.titleTextX);
        this.titleTextY = new EditBox(this.font, 88 + box.getWidth(), 20, 75, 20, this.titleTextY, (Component)Component.translatable((String)"ias.config.titleText.y"));
        this.titleTextY.setHint((Component)this.titleTextY.getMessage().copy().withStyle(ChatFormatting.DARK_GRAY));
        this.titleTextY.setTooltip(Tooltip.create((Component)Component.translatable((String)"ias.config.titleText.y.tip", (Object[])new Object[]{Component.translatable((String)"key.keyboard.left.alt")})));
        this.titleTextY.setTooltipDelay(Duration.ofMillis(250L));
        this.titleTextY.active = box.selected();
        this.titleTextY.setEditable(box.selected());
        this.titleTextY.setMaxLength(128);
        this.titleTextY.setResponder(value -> {
            IASConfig.titleTextY = value = value.isBlank() ? null : Expression.SPACE_PATTERN.matcher(value.strip()).replaceAll(" ");
            this.titleTextY.setTextColor(Expression.positionValidityColor(value, this.width, this.height, false));
        });
        this.titleTextY.setValue(Objects.requireNonNullElse(IASConfig.titleTextY, ""));
        this.addRenderableWidget((GuiEventListener)this.titleTextY);
        this.titleTextAlign = Button.builder((Component)CommonComponents.optionNameValue((Component)Component.translatable((String)"ias.config.titleTextAlign"), (Component)Component.translatable((String)IASConfig.titleTextAlign.toString())), btn -> {
            IASConfig.titleTextAlign = switch (IASConfig.titleTextAlign) {
                default -> throw new MatchException(null, null);
                case TextAlign.LEFT -> TextAlign.CENTER;
                case TextAlign.CENTER -> TextAlign.RIGHT;
                case TextAlign.RIGHT -> TextAlign.LEFT;
            };
            btn.setMessage((Component)CommonComponents.optionNameValue((Component)Component.translatable((String)"ias.config.titleTextAlign"), (Component)Component.translatable((String)IASConfig.titleTextAlign.toString())));
        }).bounds(167 + box.getWidth(), 20, Math.min(150, Math.max(20, this.width - 171 - box.getWidth())), 20).build();
        this.titleTextAlign.active = box.selected();
        this.titleTextAlign.setTooltip(Tooltip.create((Component)Component.translatable((String)"ias.config.titleTextAlign.tip")));
        this.titleTextAlign.setTooltipDelay(Duration.ofMillis(250L));
        this.addRenderableWidget((GuiEventListener)this.titleTextAlign);
        box = Checkbox.builder((Component)Component.translatable((String)"ias.config.titleButton"), (Font)this.font).pos(5, 44).selected(IASConfig.titleButton).onValueChange((cb, value) -> {
            IASConfig.titleButton = value;
            this.titleButtonX.active = value;
            this.titleButtonY.active = value;
            this.titleButtonX.setEditable(value);
            this.titleButtonY.setEditable(value);
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"ias.config.titleButton.tip"))).build();
        box.setTooltipDelay(Duration.ofMillis(250L));
        this.addRenderableWidget((GuiEventListener)box);
        this.titleButtonX = new EditBox(this.font, 9 + box.getWidth(), 44, 75, 20, this.titleButtonX, (Component)Component.translatable((String)"ias.config.titleButton.x"));
        this.titleButtonX.setHint((Component)this.titleButtonX.getMessage().copy().withStyle(ChatFormatting.DARK_GRAY));
        this.titleButtonX.setTooltip(Tooltip.create((Component)Component.translatable((String)"ias.config.titleButton.x.tip", (Object[])new Object[]{Component.translatable((String)"key.keyboard.left.alt")})));
        this.titleButtonX.setTooltipDelay(Duration.ofMillis(250L));
        this.titleButtonX.active = box.selected();
        this.titleButtonX.setEditable(box.selected());
        this.titleButtonX.setMaxLength(128);
        this.titleButtonX.setResponder(value -> {
            IASConfig.titleButtonX = value = value.isBlank() ? null : Expression.SPACE_PATTERN.matcher(value.strip()).replaceAll(" ");
            this.titleButtonX.setTextColor(Expression.positionValidityColor(value, this.width, this.height, true));
        });
        this.titleButtonX.setValue(Objects.requireNonNullElse(IASConfig.titleButtonX, ""));
        this.addRenderableWidget((GuiEventListener)this.titleButtonX);
        this.titleButtonY = new EditBox(this.font, 88 + box.getWidth(), 44, 75, 20, this.titleButtonY, (Component)Component.translatable((String)"ias.config.titleButton.y"));
        this.titleButtonY.setHint((Component)this.titleButtonY.getMessage().copy().withStyle(ChatFormatting.DARK_GRAY));
        this.titleButtonY.setTooltip(Tooltip.create((Component)Component.translatable((String)"ias.config.titleButton.y.tip", (Object[])new Object[]{Component.translatable((String)"key.keyboard.left.alt")})));
        this.titleButtonY.setTooltipDelay(Duration.ofMillis(250L));
        this.titleButtonY.active = box.selected();
        this.titleButtonY.setEditable(box.selected());
        this.titleButtonY.setMaxLength(128);
        this.titleButtonY.setResponder(value -> {
            IASConfig.titleButtonY = value = value.isBlank() ? null : Expression.SPACE_PATTERN.matcher(value.strip()).replaceAll(" ");
            this.titleButtonY.setTextColor(Expression.positionValidityColor(value, this.width, this.height, false));
        });
        this.titleButtonY.setValue(Objects.requireNonNullElse(IASConfig.titleButtonY, ""));
        this.addRenderableWidget((GuiEventListener)this.titleButtonY);
        box = Checkbox.builder((Component)Component.translatable((String)"ias.config.serversText"), (Font)this.font).pos(5, 68).selected(IASConfig.serversText).onValueChange((cb, value) -> {
            IASConfig.serversText = value;
            this.serversTextX.active = value;
            this.serversTextY.active = value;
            this.serversTextX.setEditable(value);
            this.serversTextY.setEditable(value);
            this.serversTextAlign.active = value;
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"ias.config.serversText.tip"))).build();
        box.setTooltipDelay(Duration.ofMillis(250L));
        this.addRenderableWidget((GuiEventListener)box);
        this.serversTextX = new EditBox(this.font, 9 + box.getWidth(), 68, 75, 20, this.serversTextX, (Component)Component.translatable((String)"ias.config.serversText.x"));
        this.serversTextX.setHint((Component)this.serversTextX.getMessage().copy().withStyle(ChatFormatting.DARK_GRAY));
        this.serversTextX.setTooltip(Tooltip.create((Component)Component.translatable((String)"ias.config.serversText.x.tip", (Object[])new Object[]{Component.translatable((String)"key.keyboard.left.alt")})));
        this.serversTextX.setTooltipDelay(Duration.ofMillis(250L));
        this.serversTextX.active = box.selected();
        this.serversTextX.setEditable(box.selected());
        this.serversTextX.setMaxLength(128);
        this.serversTextX.setResponder(value -> {
            IASConfig.serversTextX = value = value.isBlank() ? null : Expression.SPACE_PATTERN.matcher(value.strip()).replaceAll(" ");
            this.serversTextX.setTextColor(Expression.positionValidityColor(value, this.width, this.height, true));
        });
        this.serversTextX.setValue(Objects.requireNonNullElse(IASConfig.serversTextX, ""));
        this.addRenderableWidget((GuiEventListener)this.serversTextX);
        this.serversTextY = new EditBox(this.font, 88 + box.getWidth(), 68, 75, 20, this.serversTextY, (Component)Component.translatable((String)"ias.config.serversText.y"));
        this.serversTextY.setHint((Component)this.serversTextY.getMessage().copy().withStyle(ChatFormatting.DARK_GRAY));
        this.serversTextY.setTooltip(Tooltip.create((Component)Component.translatable((String)"ias.config.serversText.y.tip", (Object[])new Object[]{Component.translatable((String)"key.keyboard.left.alt")})));
        this.serversTextY.setTooltipDelay(Duration.ofMillis(250L));
        this.serversTextY.active = box.selected();
        this.serversTextY.setEditable(box.selected());
        this.serversTextY.setMaxLength(128);
        this.serversTextY.setResponder(value -> {
            IASConfig.serversTextY = value = value.isBlank() ? null : Expression.SPACE_PATTERN.matcher(value.strip()).replaceAll(" ");
            this.serversTextY.setTextColor(Expression.positionValidityColor(value, this.width, this.height, false));
        });
        this.serversTextY.setValue(Objects.requireNonNullElse(IASConfig.serversTextY, ""));
        this.addRenderableWidget((GuiEventListener)this.serversTextY);
        this.serversTextAlign = Button.builder((Component)CommonComponents.optionNameValue((Component)Component.translatable((String)"ias.config.serversTextAlign"), (Component)Component.translatable((String)IASConfig.serversTextAlign.toString())), btn -> {
            IASConfig.serversTextAlign = switch (IASConfig.serversTextAlign) {
                default -> throw new MatchException(null, null);
                case TextAlign.LEFT -> TextAlign.CENTER;
                case TextAlign.CENTER -> TextAlign.RIGHT;
                case TextAlign.RIGHT -> TextAlign.LEFT;
            };
            btn.setMessage((Component)CommonComponents.optionNameValue((Component)Component.translatable((String)"ias.config.serversTextAlign"), (Component)Component.translatable((String)IASConfig.serversTextAlign.toString())));
        }).bounds(167 + box.getWidth(), 68, Math.min(150, Math.max(20, this.width - 171 - box.getWidth())), 20).build();
        this.serversTextAlign.active = box.selected();
        this.serversTextAlign.setTooltip(Tooltip.create((Component)Component.translatable((String)"ias.config.serversTextAlign.tip")));
        this.serversTextAlign.setTooltipDelay(Duration.ofMillis(250L));
        this.addRenderableWidget((GuiEventListener)this.serversTextAlign);
        box = Checkbox.builder((Component)Component.translatable((String)"ias.config.serversButton"), (Font)this.font).pos(5, 92).selected(IASConfig.serversButton).onValueChange((cb, value) -> {
            IASConfig.serversButton = value;
            this.serversButtonX.active = value;
            this.serversButtonY.active = value;
            this.serversButtonX.setEditable(value);
            this.serversButtonY.setEditable(value);
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"ias.config.serversButton.tip"))).build();
        box.setTooltipDelay(Duration.ofMillis(250L));
        this.addRenderableWidget((GuiEventListener)box);
        this.serversButtonX = new EditBox(this.font, 9 + box.getWidth(), 92, 75, 20, this.serversButtonX, (Component)Component.translatable((String)"ias.config.serversButton.x"));
        this.serversButtonX.setHint((Component)this.serversButtonX.getMessage().copy().withStyle(ChatFormatting.DARK_GRAY));
        this.serversButtonX.setTooltip(Tooltip.create((Component)Component.translatable((String)"ias.config.serversButton.x.tip", (Object[])new Object[]{Component.translatable((String)"key.keyboard.left.alt")})));
        this.serversButtonX.setTooltipDelay(Duration.ofMillis(250L));
        this.serversButtonX.active = box.selected();
        this.serversButtonX.setEditable(box.selected());
        this.serversButtonX.setMaxLength(128);
        this.serversButtonX.setResponder(value -> {
            IASConfig.serversButtonX = value = value.isBlank() ? null : Expression.SPACE_PATTERN.matcher(value.strip()).replaceAll(" ");
            this.serversButtonX.setTextColor(Expression.positionValidityColor(value, this.width, this.height, true));
        });
        this.serversButtonX.setValue(Objects.requireNonNullElse(IASConfig.serversButtonX, ""));
        this.addRenderableWidget((GuiEventListener)this.serversButtonX);
        this.serversButtonY = new EditBox(this.font, 88 + box.getWidth(), 92, 75, 20, this.serversButtonY, (Component)Component.translatable((String)"ias.config.serversButton.y"));
        this.serversButtonY.setHint((Component)this.serversButtonY.getMessage().copy().withStyle(ChatFormatting.DARK_GRAY));
        this.serversButtonY.setTooltip(Tooltip.create((Component)Component.translatable((String)"ias.config.serversButton.y.tip", (Object[])new Object[]{Component.translatable((String)"key.keyboard.left.alt")})));
        this.serversButtonY.setTooltipDelay(Duration.ofMillis(250L));
        this.serversButtonY.active = box.selected();
        this.serversButtonY.setEditable(box.selected());
        this.serversButtonY.setMaxLength(128);
        this.serversButtonY.setResponder(value -> {
            IASConfig.serversButtonY = value = value.isBlank() ? null : Expression.SPACE_PATTERN.matcher(value.strip()).replaceAll(" ");
            this.serversButtonY.setTextColor(Expression.positionValidityColor(value, this.width, this.height, false));
        });
        this.serversButtonY.setValue(Objects.requireNonNullElse(IASConfig.serversButtonY, ""));
        this.addRenderableWidget((GuiEventListener)this.serversButtonY);
        box = Checkbox.builder((Component)Component.translatable((String)"ias.config.allowNoCrypt"), (Font)this.font).pos(5, 116).selected(IASConfig.allowNoCrypt).onValueChange((cb, value) -> {
            IASConfig.allowNoCrypt = value;
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"ias.config.allowNoCrypt.tip"))).build();
        box.setTooltipDelay(Duration.ofMillis(250L));
        this.addRenderableWidget((GuiEventListener)box);
        Button button = Button.builder((Component)CommonComponents.optionNameValue((Component)Component.translatable((String)"ias.config.server"), (Component)Component.translatable((String)IASConfig.server.toString())), btn -> {
            IASConfig.server = switch (IASConfig.server) {
                default -> throw new MatchException(null, null);
                case ServerMode.ALWAYS -> ServerMode.AVAILABLE;
                case ServerMode.AVAILABLE -> ServerMode.NEVER;
                case ServerMode.NEVER -> ServerMode.ALWAYS;
            };
            btn.setMessage((Component)CommonComponents.optionNameValue((Component)Component.translatable((String)"ias.config.server"), (Component)Component.translatable((String)IASConfig.server.toString())));
        }).bounds(9 + box.getWidth(), 116, 200, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"ias.config.server.tip"))).build();
        button.setTooltipDelay(Duration.ofMillis(250L));
        this.addRenderableWidget((GuiEventListener)button);
        box = Checkbox.builder((Component)Component.translatable((String)"ias.config.nickWarns"), (Font)this.font).pos(5, 140).selected(IASConfig.nickWarns).onValueChange((cb, value) -> {
            IASConfig.nickWarns = value;
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"ias.config.nickWarns.tip"))).build();
        box.setTooltipDelay(Duration.ofMillis(250L));
        this.addRenderableWidget((GuiEventListener)box);
        box = Checkbox.builder((Component)Component.translatable((String)"ias.config.passwordEchoing"), (Font)this.font).pos(10 + box.getWidth(), 140).selected(IASConfig.passwordEchoing).onValueChange((cb, value) -> {
            IASConfig.passwordEchoing = value;
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"ias.config.passwordEchoing.tip"))).build();
        box.setTooltipDelay(Duration.ofMillis(250L));
        this.addRenderableWidget((GuiEventListener)box);
        box = Checkbox.builder((Component)Component.translatable((String)"ias.config.unexpectedPigs"), (Font)this.font).pos(5, 164).selected(IASConfig.unexpectedPigs).onValueChange((cb, value) -> {
            IASConfig.unexpectedPigs = value;
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)(value ? SoundEvents.PIG_AMBIENT : SoundEvents.PIG_DEATH), (float)1.0f));
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"ias.config.unexpectedPigs.tip"))).build();
        box.setTooltipDelay(Duration.ofMillis(250L));
        this.addRenderableWidget((GuiEventListener)box);
        box = Checkbox.builder((Component)Component.translatable((String)"ias.config.barNick"), (Font)this.font).pos(5, 188).selected(IASConfig.barNick).onValueChange((cb, value) -> {
            IASConfig.barNick = value;
            this.minecraft.updateTitle();
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"ias.config.barNick.tip"))).build();
        box.setTooltipDelay(Duration.ofMillis(250L));
        this.addRenderableWidget((GuiEventListener)box);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, btn -> this.onClose()).bounds(this.width / 2 - 100, this.height - 24, 200, 20).build());
    }

    public void onClose() {
        assert (this.minecraft != null);
        try {
            IAS.disclaimersStorage();
            IAS.saveConfig();
        }
        catch (Throwable t) {
            LOGGER.error("IAS: Unable to save config.", t);
        }
        this.minecraft.setScreen(this.parent);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 5, -1);
        if (this.minecraft.hasAltDown()) {
            graphics.setTooltipForNextFrame(this.font, (Component)Component.translatable((String)"ias.config.mousePos", (Object[])new Object[]{mouseX, mouseY}), mouseX, mouseY);
        }
    }

    public String toString() {
        return "ConfigScreen{}";
    }
}

