/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.screen;

import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.joml.Matrix3x2fStack;
import org.lwjgl.glfw.GLFW;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.config.IASConfig;
import ru.vidtu.ias.crypt.DummyCrypt;
import ru.vidtu.ias.crypt.HardwareCrypt;
import ru.vidtu.ias.screen.MicrosoftPopupScreen;
import ru.vidtu.ias.screen.PopupButton;

final class MicrosoftCryptPopupScreen
extends Screen {
    private final Screen parent;
    private final Consumer<Account> handler;
    private PopupButton plain;

    MicrosoftCryptPopupScreen(Screen parent, Consumer<Account> handler) {
        super((Component)Component.translatable((String)"ias.microsoft"));
        this.parent = parent;
        this.handler = handler;
    }

    protected void init() {
        assert (this.minecraft != null);
        if (this.parent != null) {
            this.parent.init(this.minecraft, this.width, this.height);
        }
        PopupButton button = new PopupButton(this.width / 2 - 75, this.height / 2 - 24 - 12, 150, 20, (Component)Component.translatable((String)"ias.microsoft.password"), btn -> this.minecraft.setScreen((Screen)new MicrosoftPopupScreen(this.parent, this.handler, null)), Supplier::get);
        button.setTooltip(Tooltip.create((Component)Component.translatable((String)"ias.microsoft.password.tip")));
        button.setTooltipDelay(Duration.ofMillis(250L));
        button.color(0.5f, 1.0f, 0.5f, true);
        this.addRenderableWidget((GuiEventListener)button);
        button = new PopupButton(this.width / 2 - 75, this.height / 2 - 12, 150, 20, (Component)Component.translatable((String)"ias.microsoft.hardware"), btn -> this.minecraft.setScreen((Screen)new MicrosoftPopupScreen(this.parent, this.handler, HardwareCrypt.INSTANCE_V2)), Supplier::get);
        button.setTooltip(Tooltip.create((Component)Component.translatable((String)"ias.microsoft.hardware.tip")));
        button.setTooltipDelay(Duration.ofMillis(250L));
        button.color(1.0f, 1.0f, 0.5f, true);
        this.addRenderableWidget((GuiEventListener)button);
        this.plain = new PopupButton(this.width / 2 - 75, this.height / 2 + 12, 150, 20, (Component)Component.translatable((String)"ias.microsoft.plain"), btn -> this.minecraft.setScreen((Screen)new MicrosoftPopupScreen(this.parent, this.handler, DummyCrypt.INSTANCE)), Supplier::get);
        if (IASConfig.allowNoCrypt) {
            this.plain.setTooltip(Tooltip.create((Component)Component.translatable((String)"ias.microsoft.plain.tip.off", (Object[])new Object[]{Component.translatable((String)"key.keyboard.left.alt"), GLFW.glfwGetKeyName((int)89, (int)-1)})));
        } else {
            this.plain.setTooltip(Tooltip.create((Component)Component.translatable((String)"ias.microsoft.plain.tip.no")));
        }
        this.plain.setTooltipDelay(Duration.ofMillis(250L));
        this.plain.color(1.0f, 0.5f, 0.5f, true);
        this.plain.active = false;
        this.addRenderableWidget((GuiEventListener)this.plain);
        this.addRenderableWidget((GuiEventListener)new PopupButton(this.width / 2 - 75, this.height / 2 + 79 - 22, 150, 20, CommonComponents.GUI_CANCEL, btn -> this.onClose(), Supplier::get));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        assert (this.minecraft != null);
        Matrix3x2fStack pose = graphics.pose();
        super.render(graphics, mouseX, mouseY, delta);
        pose.pushMatrix();
        pose.scale(2.0f, 2.0f);
        graphics.drawCenteredString(this.font, this.title, this.width / 4, this.height / 4 - 39, -1);
        pose.popMatrix();
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        assert (this.minecraft != null);
        if (this.parent != null) {
            this.parent.renderWithTooltipAndSubtitles(graphics, 0, 0, delta);
            graphics.nextStratum();
            graphics.fill(0, 0, this.width, this.height, Integer.MIN_VALUE);
        } else {
            super.renderBackground(graphics, mouseX, mouseY, delta);
        }
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        graphics.fill(centerX - 80, centerY - 80, centerX + 80, centerY + 80, -132112336);
        graphics.fill(centerX - 79, centerY - 81, centerX + 79, centerY - 80, -132112336);
        graphics.fill(centerX - 79, centerY + 80, centerX + 79, centerY + 81, -132112336);
    }

    public void onClose() {
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
    }

    public boolean keyPressed(KeyEvent event) {
        int key = event.key();
        boolean alt = event.hasAltDown();
        if (key == 89 && IASConfig.allowNoCrypt && this.plain != null && !this.plain.isActive() && alt) {
            this.plain.active = true;
            this.plain.setTooltip(Tooltip.create((Component)Component.translatable((String)"ias.microsoft.plain.tip.on")));
            this.plain.setTooltipDelay(Duration.ofMillis(250L));
            this.plain.color(1.0f, 0.25f, 0.25f, false);
        }
        return super.keyPressed(event);
    }

    public String toString() {
        return "MicrosoftCryptPopupScreen{}";
    }
}

