/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.screen;

import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.joml.Matrix3x2fStack;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.account.OfflineAccount;
import ru.vidtu.ias.auth.microsoft.MSAuth;
import ru.vidtu.ias.config.IASConfig;
import ru.vidtu.ias.screen.PopupBox;
import ru.vidtu.ias.screen.PopupButton;

public final class OfflinePopupScreen
extends Screen {
    private final Screen parent;
    private final Consumer<Account> handler;
    private PopupBox name;
    private PopupButton done;
    private boolean locked = false;

    OfflinePopupScreen(Screen parent, Consumer<Account> handler) {
        super((Component)Component.translatable((String)"ias.offline"));
        this.parent = parent;
        this.handler = handler;
    }

    protected void init() {
        assert (this.minecraft != null);
        if (this.parent != null) {
            this.parent.init(this.minecraft, this.width, this.height);
        }
        this.name = new PopupBox(this.font, this.width / 2 - 75, this.height / 2 - 10 + 5, 148, 20, this.name, (Component)Component.translatable((String)"ias.offline.nick"), this::done, false);
        this.name.setMaxLength(16);
        if (IASConfig.unexpectedPigs) {
            this.name.setHint((Component)Component.literal((String)("Boar" + ((Object)((Object)this)).hashCode())).withStyle(ChatFormatting.DARK_GRAY));
        } else {
            this.name.setHint((Component)Component.literal((String)"Steve").withStyle(ChatFormatting.DARK_GRAY));
        }
        this.addRenderableWidget((GuiEventListener)this.name);
        this.done = new PopupButton(this.width / 2 - 75, this.height / 2 + 49 - 22, 74, 20, CommonComponents.GUI_DONE, btn -> this.done(), Supplier::get);
        this.done.color(1.0f, 0.5f, 0.5f, true);
        this.addRenderableWidget((GuiEventListener)this.done);
        PopupButton button = new PopupButton(this.width / 2 + 1, this.height / 2 + 49 - 22, 74, 20, CommonComponents.GUI_CANCEL, btn -> this.onClose(), Supplier::get);
        button.color(1.0f, 1.0f, 1.0f, true);
        this.addRenderableWidget((GuiEventListener)button);
        this.name.setResponder(value -> this.type(false));
        this.type(true);
    }

    private void done() {
        assert (this.minecraft != null);
        if (this.name == null) {
            return;
        }
        String value = this.name.getValue();
        if (value.isBlank()) {
            return;
        }
        int length = value.length();
        if (length < 3 || length > 16) {
            this.handler.accept(new OfflineAccount(value, null));
            return;
        }
        for (int i = 0; i < length; ++i) {
            int c = value.codePointAt(i);
            if (c == 95 || c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90) continue;
            this.handler.accept(new OfflineAccount(value, null));
            return;
        }
        this.locked = true;
        this.type(false);
        MSAuth.nameToMcp(value).whenCompleteAsync((profile, throwable) -> {
            UUID skin = profile != null ? profile.uuid() : null;
            this.handler.accept(new OfflineAccount(value, skin));
        }, (Executor)this.minecraft);
    }

    private void type(boolean instant) {
        if (this.done == null || this.name == null) {
            return;
        }
        if (this.locked) {
            this.done.active = false;
            this.name.active = false;
            this.done.setTooltip(null);
            this.done.color(0.5f, 0.5f, 0.5f, instant);
            return;
        }
        String value = this.name.getValue();
        this.name.active = true;
        if (value.isBlank()) {
            this.done.active = false;
            this.done.setTooltip(Tooltip.create((Component)Component.translatable((String)"ias.offline.nick.blank")));
            this.done.setTooltipDelay(Duration.ZERO);
            this.done.color(1.0f, 0.5f, 0.5f, instant);
            return;
        }
        this.done.active = true;
        int length = value.length();
        if (length < 3) {
            if (this.minecraft.hasAltDown()) {
                this.done.active = true;
                this.done.color(0.75f, 0.75f, 0.25f, instant);
            } else {
                this.done.active = false;
                this.done.color(1.0f, 1.0f, 0.5f, instant);
            }
            this.done.setTooltip(Tooltip.create((Component)Component.translatable((String)"ias.offline.nick.short", (Object[])new Object[]{Component.translatable((String)"key.keyboard.left.alt")})));
            this.done.setTooltipDelay(Duration.ZERO);
            return;
        }
        if (length > 16) {
            if (this.minecraft.hasAltDown()) {
                this.done.active = true;
                this.done.color(0.75f, 0.75f, 0.25f, instant);
            } else {
                this.done.active = false;
                this.done.color(1.0f, 1.0f, 0.5f, instant);
            }
            this.done.setTooltip(Tooltip.create((Component)Component.translatable((String)"ias.offline.nick.long", (Object[])new Object[]{Component.translatable((String)"key.keyboard.left.alt")})));
            this.done.setTooltipDelay(Duration.ZERO);
            return;
        }
        for (int i = 0; i < length; ++i) {
            boolean alt;
            int c = value.codePointAt(i);
            if (c == 95 || c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90) continue;
            this.done.active = alt = this.minecraft.hasAltDown();
            if (alt) {
                this.done.active = true;
                this.done.color(0.75f, 0.75f, 0.25f, instant);
            } else {
                this.done.active = false;
                this.done.color(1.0f, 1.0f, 0.5f, instant);
            }
            this.done.setTooltip(Tooltip.create((Component)Component.translatable((String)"ias.offline.nick.chars", (Object[])new Object[]{Character.toString(c), Component.translatable((String)"key.keyboard.left.alt")})));
            this.done.setTooltipDelay(Duration.ZERO);
            return;
        }
        this.done.color(0.5f, 1.0f, 0.5f, instant);
        this.done.setTooltip(null);
    }

    public boolean keyPressed(KeyEvent event) {
        int key = event.key();
        boolean res = super.keyPressed(event);
        if (key == 342 || key == 346) {
            this.type(false);
        }
        return res;
    }

    public boolean keyReleased(KeyEvent event) {
        int key = event.key();
        boolean res = super.keyReleased(event);
        if (key == 342 || key == 346) {
            this.type(false);
        }
        return res;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        assert (this.minecraft != null);
        Matrix3x2fStack pose = graphics.pose();
        super.render(graphics, mouseX, mouseY, delta);
        pose.pushMatrix();
        pose.scale(2.0f, 2.0f);
        graphics.drawCenteredString(this.font, this.title, this.width / 4, this.height / 4 - 24, -1);
        pose.popMatrix();
        if (this.name != null) {
            graphics.drawCenteredString(this.font, this.name.getMessage(), this.width / 2, this.height / 2 - 10 - 5, -1);
        }
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        assert (this.minecraft != null);
        if (this.parent != null) {
            this.parent.renderWithTooltipAndSubtitles(graphics, 0, 0, delta);
            graphics.nextStratum();
            graphics.fill(0, 0, this.width, this.height, Integer.MIN_VALUE);
        } else {
            super.renderBackground(graphics, mouseX, mouseY, delta);
        }
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        graphics.fill(centerX - 80, centerY - 50, centerX + 80, centerY + 50, -132112336);
        graphics.fill(centerX - 79, centerY - 51, centerX + 79, centerY - 50, -132112336);
        graphics.fill(centerX - 79, centerY + 50, centerX + 79, centerY + 51, -132112336);
    }

    public void onClose() {
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
    }

    public String toString() {
        return "OfflinePopupScreen{}";
    }
}

