/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.screen;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

final class PopupBox
extends EditBox {
    private final Runnable enterAction;
    private final boolean secure;

    PopupBox(Font font, int x, int y, int width, int height, PopupBox inherit, Component title, Runnable enterAction, boolean secure) {
        super(font, x, y, width, height, (EditBox)inherit, title);
        this.enterAction = enterAction;
        this.secure = secure;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        graphics.fill(x + 1, y + 1, x + width - 1, y + height - 1, -16777216);
        graphics.fill(x + 1, y, x + width - 1, y + 1, -1);
        graphics.fill(x + 1, y + height - 1, x + width - 1, y + height, -1);
        graphics.fill(x, y + 1, x + 1, y + height - 1, -1);
        graphics.fill(x + width - 1, y + 1, x + width, y + height - 1, -1);
        super.renderWidget(graphics, mouseX, mouseY, delta);
    }

    public boolean keyPressed(KeyEvent event) {
        int key = event.key();
        if (this.enterAction != null && this.isActive() && this.isFocused() && (key == 257 || key == 335)) {
            this.enterAction.run();
            return true;
        }
        if (this.secure && (event.isCopy() || event.isCut())) {
            return true;
        }
        return super.keyPressed(event);
    }

    @NotNull
    protected MutableComponent createNarrationMessage() {
        if (!this.secure) {
            return super.createNarrationMessage();
        }
        return Component.translatable((String)"gui.narrate.editBox", (Object[])new Object[]{this.getMessage(), Component.empty()});
    }

    public boolean isBordered() {
        return false;
    }

    public String toString() {
        return "PopupBox{secure=" + this.secure + "}";
    }
}

