/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.screen;

import com.mojang.blaze3d.platform.cursor.CursorTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

final class PopupButton
extends Button {
    private float red = 1.0f;
    private float green = 1.0f;
    private float blue = 1.0f;
    private float currentRed = 1.0f;
    private float currentGreen = 1.0f;
    private float currentBlue = 1.0f;
    private float multiplier = 1.0f;

    PopupButton(int x, int y, int width, int height, Component text, Button.OnPress press, Button.CreateNarration narration) {
        super(x, y, width, height, text, press, narration);
    }

    void color(float red, float green, float blue, boolean instant) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        if (!instant) {
            return;
        }
        this.currentRed = red;
        this.currentGreen = green;
        this.currentBlue = blue;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        Component message = this.getMessage();
        this.multiplier = this.isHoveredOrFocused() && this.isActive() ? Mth.clamp((float)(this.multiplier - delta * 0.25f), (float)0.75f, (float)1.0f) : Mth.clamp((float)(this.multiplier + delta * 0.25f), (float)0.75f, (float)1.0f);
        this.currentRed += (this.red - this.currentRed) * delta;
        this.currentGreen += (this.green - this.currentGreen) * delta;
        this.currentBlue += (this.blue - this.currentBlue) * delta;
        int r = (int)(this.multiplier * 255.0f * this.currentRed);
        int g = (int)(this.multiplier * 255.0f * this.currentGreen);
        int b = (int)(this.multiplier * 255.0f * this.currentBlue);
        int color = 0xFF000000 | r << 16 | g << 8 | b;
        graphics.fill(x, y + 1, x + width, y + height - 1, color);
        graphics.fill(x + 1, y, x + width - 1, y + 1, color);
        graphics.fill(x + 1, y + height - 1, x + width - 1, y + height, color);
        graphics.drawString(font, message, x + (width - font.width((FormattedText)message)) / 2, y + height / 2 - 4, -16777216, false);
        if (this.isHovered()) {
            graphics.requestCursor(this.isActive() ? CursorTypes.POINTING_HAND : CursorTypes.NOT_ALLOWED);
        }
    }

    public String toString() {
        return "PopupButton{red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ", currentRed=" + this.currentRed + ", currentGreen=" + this.currentGreen + ", currentBlue=" + this.currentBlue + ", multiplier=" + this.multiplier + "}";
    }
}

