/*
 * Decompiled with CFR 0.152.
 */
package com.github.prohect;

import com.github.prohect.KeyBindingPlus;
import com.github.prohect.KeyPressed;
import com.github.prohect.alias.Alias;
import com.github.prohect.alias.AliasWithoutArgs;
import com.github.prohect.alias.UserAlias;
import com.github.prohect.alias.builtinAlias.AliasAlias;
import com.github.prohect.alias.builtinAlias.AttackAlias;
import com.github.prohect.alias.builtinAlias.BackAlias;
import com.github.prohect.alias.builtinAlias.BindAlias;
import com.github.prohect.alias.builtinAlias.DropAlias;
import com.github.prohect.alias.builtinAlias.ForwardAlias;
import com.github.prohect.alias.builtinAlias.JumpAlias;
import com.github.prohect.alias.builtinAlias.LeftAlias;
import com.github.prohect.alias.builtinAlias.LogAlias;
import com.github.prohect.alias.builtinAlias.PitchAlias;
import com.github.prohect.alias.builtinAlias.ReloadCFGAlias;
import com.github.prohect.alias.builtinAlias.RightAlias;
import com.github.prohect.alias.builtinAlias.SayAlias;
import com.github.prohect.alias.builtinAlias.SendCommandAlias;
import com.github.prohect.alias.builtinAlias.SetPitchAlias;
import com.github.prohect.alias.builtinAlias.SetYawAlias;
import com.github.prohect.alias.builtinAlias.SlotAlias;
import com.github.prohect.alias.builtinAlias.SneakAlias;
import com.github.prohect.alias.builtinAlias.SprintAlias;
import com.github.prohect.alias.builtinAlias.SwapHandAlias;
import com.github.prohect.alias.builtinAlias.SwapSlotAlias;
import com.github.prohect.alias.builtinAlias.UnbindAlias;
import com.github.prohect.alias.builtinAlias.UseAlias;
import com.github.prohect.alias.builtinAlias.WaitAlias;
import com.github.prohect.alias.builtinAlias.YawAlias;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class BindAliasPlusClient
implements ClientModInitializer {
    public static final BindAliasPlusClient INSTANCE = new BindAliasPlusClient();
    public static final Path cfgPath = FabricLoader.getInstance().getConfigDir().resolve("bind-alias-plus.cfg");
    public static final ArrayDeque<KeyPressed> KEY_QUEUE = new ArrayDeque();
    public static final Map<class_3675.class_306, KeyBindingPlus> BINDING_PLUS = new HashMap<class_3675.class_306, KeyBindingPlus>();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"bind-alias-plus");

    public void onInitializeClient() {
        new AttackAlias().putToAliasesWithArgs_notSuggested("builtinAttack");
        new UseAlias().putToAliasesWithArgs_notSuggested("builtinUse");
        new ForwardAlias().putToAliasesWithArgs_notSuggested("builtinForward");
        new BackAlias().putToAliasesWithArgs_notSuggested("builtinBack");
        new LeftAlias().putToAliasesWithArgs_notSuggested("builtinLeft");
        new RightAlias().putToAliasesWithArgs_notSuggested("builtinRight");
        new JumpAlias().putToAliasesWithArgs_notSuggested("builtinJump");
        new SneakAlias().putToAliasesWithArgs_notSuggested("builtinSneak");
        new SprintAlias().putToAliasesWithArgs_notSuggested("builtinSprint");
        ((DropAlias)new DropAlias().putToAliasesWithArgs_notSuggested("builtinDrop")).addToLockCursorBlackList();
        new LogAlias().putToAliasesWithArgs("log");
        new SlotAlias().putToAliasesWithArgs("slot");
        new SwapSlotAlias().putToAliasesWithArgs("swapSlot");
        WaitAlias waitAlias = (WaitAlias)new WaitAlias().putToAliasesWithArgs("wait");
        new YawAlias().putToAliasesWithArgs("yaw");
        new PitchAlias().putToAliasesWithArgs("pitch");
        new SetYawAlias().putToAliasesWithArgs("setYaw");
        new SetPitchAlias().putToAliasesWithArgs("setPitch");
        new AliasAlias().putToAliasesWithArgs("alias");
        new BindAlias().putToAliasesWithArgs("bind");
        new UnbindAlias().putToAliasesWithArgs("unbind");
        new SayAlias().putToAliasesWithArgs("say");
        new SendCommandAlias().putToAliasesWithArgs("sendCommand");
        new SwapHandAlias().putToAliasesWithoutArgs("swapHand");
        new ReloadCFGAlias().putToAliasesWithoutArgs("reloadCFG");
        new UserAlias("builtinAttack\\1").putToAliasesWithoutArgs("+attack");
        new UserAlias("builtinAttack\\0").putToAliasesWithoutArgs("-attack");
        new UserAlias("builtinUse\\1").putToAliasesWithoutArgs("+use");
        new UserAlias("builtinUse\\0").putToAliasesWithoutArgs("-use");
        new UserAlias("builtinForward\\1").putToAliasesWithoutArgs("+forward");
        new UserAlias("builtinForward\\0").putToAliasesWithoutArgs("-forward");
        new UserAlias("builtinBack\\1").putToAliasesWithoutArgs("+back");
        new UserAlias("builtinBack\\0").putToAliasesWithoutArgs("-back");
        new UserAlias("builtinLeft\\1").putToAliasesWithoutArgs("+left");
        new UserAlias("builtinLeft\\0").putToAliasesWithoutArgs("-left");
        new UserAlias("builtinRight\\1").putToAliasesWithoutArgs("+right");
        new UserAlias("builtinRight\\0").putToAliasesWithoutArgs("-right");
        new UserAlias("builtinJump\\1").putToAliasesWithoutArgs("+jump");
        new UserAlias("builtinJump\\0").putToAliasesWithoutArgs("-jump");
        new UserAlias("builtinSneak\\1").putToAliasesWithoutArgs("+sneak");
        new UserAlias("builtinSneak\\0").putToAliasesWithoutArgs("-sneak");
        new UserAlias("builtinSprint\\1").putToAliasesWithoutArgs("+sprint");
        new UserAlias("builtinSprint\\0").putToAliasesWithoutArgs("-sprint");
        new UserAlias("builtinDrop\\0").putToAliasesWithoutArgs("drop");
        new UserAlias("builtinDrop\\1").putToAliasesWithoutArgs("dropStack");
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"alias").then(ClientCommandManager.argument((String)"keyName", (ArgumentType)StringArgumentType.word()).then(ClientCommandManager.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> BindAliasPlusClient.getSuggestions4aliasDefinitionCompletableFuture(builder)).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"keyName");
            String definition = StringArgumentType.getString((CommandContext)context, (String)"args");
            return switch (this.commandAliasExecute(name, definition)) {
                case 1 -> {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Alias " + name + " = " + definition)));
                    yield 1;
                }
                case 2, 3 -> {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Can't replace builtinAlias " + name)));
                    yield 0;
                }
                default -> 0;
            };
        })))));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"bindByAliasName").then(ClientCommandManager.argument((String)"key", (ArgumentType)StringArgumentType.word()).then(ClientCommandManager.argument((String)"aliasName", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            Alias.aliasesWithoutArgs.keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(context -> {
            String keyName = StringArgumentType.getString((CommandContext)context, (String)"key");
            String aliasName = StringArgumentType.getString((CommandContext)context, (String)"aliasName");
            return switch (this.commandBindByAliasNameExecute(keyName, aliasName)) {
                case 1 -> {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aBound key " + keyName + " to alias " + aliasName)));
                    yield 1;
                }
                case 2, 3 -> {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7cAlias " + aliasName + " does not exist!")));
                    yield 0;
                }
                case 4 -> {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7cUnknown key: " + keyName)));
                    yield 0;
                }
                default -> 0;
            };
        })))));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"bind").then(ClientCommandManager.argument((String)"key", (ArgumentType)StringArgumentType.word()).then(ClientCommandManager.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> BindAliasPlusClient.getSuggestions4aliasDefinitionCompletableFuture(builder)).executes(context -> {
            String keyName = StringArgumentType.getString((CommandContext)context, (String)"key");
            String definition = StringArgumentType.getString((CommandContext)context, (String)"args");
            return switch (this.commandBindExecute(keyName, definition)) {
                case 1 -> {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aBound key " + keyName + " to alias " + definition)));
                    yield 1;
                }
                case 2 -> {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7cUnknown key: " + keyName)));
                    yield 0;
                }
                case 3 -> {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("bind " + keyName + " = " + definition)));
                    yield 0;
                }
                default -> 0;
            };
        })))));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"unbind").then(ClientCommandManager.argument((String)"key", (ArgumentType)StringArgumentType.word()).executes(context -> {
            String keyName = StringArgumentType.getString((CommandContext)context, (String)"key");
            return switch (this.commandUnbindExecute(keyName)) {
                case 0 -> {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7cUnknown key: " + keyName)));
                    yield 0;
                }
                case 1 -> {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7cUnbind key: " + keyName)));
                    yield 1;
                }
                default -> 0;
            };
        }))));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"reloadCFG").executes(context -> {
            if (class_310.method_1551().field_1724 == null) {
                return 0;
            }
            this.loadCFG();
            return 1;
        })));
        ClientPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (class_310.method_1551().field_1724 != null) {
                waitAlias.run("1", "reloadCFG");
            }
        });
    }

    public void loadCFG() {
        try {
            if (cfgPath.toFile().createNewFile()) {
                return;
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not create file {}", (Object)cfgPath, (Object)e);
        }
        byte[] data = null;
        try (InputStream inputStream = Files.newInputStream(cfgPath, new OpenOption[0]);){
            data = new byte[inputStream.available()];
            while (inputStream.available() > 0) {
                inputStream.read(data);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to open cfg file", (Throwable)e);
        }
        if (data == null) {
            return;
        }
        String cfg = new String(data);
        assert (class_310.method_1551().field_1724 != null);
        cfg.lines().forEach(line -> {
            try {
                if (line.startsWith("alias ")) {
                    String string = line.substring("alias ".length());
                    int i = string.indexOf(32);
                    String substring = string.substring(0, i);
                    this.commandAliasExecute(substring, string.substring(i + 1));
                } else if (line.startsWith("bind ")) {
                    String string = line.substring("bind ".length());
                    int i = string.indexOf(32);
                    String substring = string.substring(0, i);
                    this.commandBindExecute(substring, string.substring(i + 1));
                } else if (line.startsWith("bindByAliasName ")) {
                    String string = line.substring("bindByAliasName ".length());
                    int i = string.indexOf(32);
                    String substring = string.substring(0, i);
                    this.commandBindByAliasNameExecute(substring, string.substring(i + 1));
                } else if (line.startsWith("unbind ")) {
                    String string = line.substring("unbind ".length());
                    if (string.indexOf(32) == -1) {
                        this.commandUnbindExecute(string);
                    }
                } else {
                    LOGGER.warn("Unknown command: {}", line);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to load CFG file", (Throwable)e);
            }
        });
    }

    private int commandUnbindExecute(String keyName) {
        class_3675.class_306 key = this.parseKey(keyName);
        if (key == null) {
            return 0;
        }
        BINDING_PLUS.remove(key);
        return 1;
    }

    private int commandBindExecute(String keyName, String args) {
        int i;
        if (this.commandBindByAliasNameExecute(keyName, args) == 1) {
            return 1;
        }
        StringBuilder aliasName = new StringBuilder();
        StringBuilder aliasName1 = new StringBuilder();
        String CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        Random rng = new Random();
        for (i = 0; i < 16; ++i) {
            aliasName.append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".charAt(rng.nextInt("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".length())));
        }
        for (i = 0; i < 16; ++i) {
            aliasName1.append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".charAt(rng.nextInt("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".length())));
        }
        class_3675.class_306 key = this.parseKey(keyName);
        if (key == null) {
            return 2;
        }
        Alias.aliasesWithoutArgs_fromBindCommand.put(String.valueOf(aliasName), new UserAlias(args));
        String oppositeDefinition = Alias.getOppositeDefinition(args);
        if (!oppositeDefinition.isBlank()) {
            Alias.aliasesWithoutArgs_fromBindCommand.put(String.valueOf(aliasName1), new UserAlias(oppositeDefinition));
        }
        BINDING_PLUS.put(key, new KeyBindingPlus(aliasName.toString(), oppositeDefinition.isBlank() ? "" : aliasName1.toString()));
        return 3;
    }

    private int commandAliasExecute(String aliasName, String definition) {
        if (Alias.aliasesWithArgs_notSuggested.containsKey(aliasName) || Alias.aliasesWithArgs.containsKey(aliasName)) {
            return 2;
        }
        AliasWithoutArgs<?> aliasWithoutArgs = Alias.aliasesWithoutArgs.get(aliasName);
        if (aliasWithoutArgs != null && !(aliasWithoutArgs instanceof UserAlias)) {
            return 3;
        }
        Alias.aliasesWithoutArgs.put(aliasName, new UserAlias(definition));
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int commandBindByAliasNameExecute(String keyName, String aliasName) {
        Object aliasNameFinalExtra;
        String aliasNameFinal;
        class_3675.class_306 key;
        boolean flag0 = true;
        boolean flag = true;
        boolean flag1 = true;
        AliasWithoutArgs<?> alias = Alias.aliasesWithoutArgs.get(aliasName);
        if (alias == null) {
            flag1 = false;
            if (!aliasName.startsWith("+") && !aliasName.startsWith("-")) return 3;
            alias = Alias.aliasesWithoutArgs.get(aliasName.substring(1));
            if (alias == null) {
                return 2;
            }
            if (aliasName.startsWith("-")) {
                flag = false;
            }
        } else {
            flag = !aliasName.startsWith("-");
            boolean bl = flag0 = flag || aliasName.startsWith("-");
        }
        if ((key = this.parseKey(keyName)) == null) {
            return 4;
        }
        String string = aliasNameFinal = flag1 ? aliasName : aliasName.substring(1);
        Object object = flag ? (flag1 ? "-" + aliasNameFinal.substring(1) : "-" + aliasNameFinal) : (aliasNameFinalExtra = flag1 ? "+" + aliasNameFinal.substring(1) : "+" + aliasNameFinal);
        if (flag0) {
            AliasWithoutArgs<?> aliasWithoutArgs = Alias.aliasesWithoutArgs.get(aliasNameFinalExtra);
            if (aliasWithoutArgs == null) {
                aliasNameFinalExtra = "";
            }
        } else {
            aliasNameFinalExtra = "";
        }
        BINDING_PLUS.put(key, flag ? new KeyBindingPlus(aliasNameFinal, (String)aliasNameFinalExtra) : new KeyBindingPlus((String)aliasNameFinalExtra, aliasNameFinal));
        return 1;
    }

    private static CompletableFuture<Suggestions> getSuggestions4aliasDefinitionCompletableFuture(SuggestionsBuilder builder) {
        String soFar = builder.getRemaining();
        if (soFar.isBlank()) {
            SuggestionsBuilder finalBuilder = builder;
            Alias.aliasesWithoutArgs.forEach((name, alias) -> finalBuilder.suggest(name));
            Alias.aliasesWithArgs.forEach((name, alias) -> finalBuilder.suggest(name));
            return builder.buildFuture();
        }
        int a = soFar.lastIndexOf(92);
        int n = soFar.lastIndexOf(32);
        if (n < a) {
            return builder.buildFuture();
        }
        String currentToken = soFar.substring(n + 1);
        SuggestionsBuilder finalBuilder = builder = builder.createOffset(builder.getStart() + n + 1);
        Alias.aliasesWithoutArgs.keySet().forEach(alias -> {
            if (alias.startsWith(currentToken)) {
                finalBuilder.suggest(alias, (Message)class_2561.method_43470((String)"alias without args"));
            }
        });
        Alias.aliasesWithArgs.keySet().forEach(alias -> {
            if (alias.startsWith(currentToken)) {
                finalBuilder.suggest(alias, (Message)class_2561.method_43470((String)"alias with args"));
            }
        });
        return builder.buildFuture();
    }

    private class_3675.class_306 parseKey(String name) {
        class_3675.class_306 key = null;
        try {
            key = class_3675.method_15981((String)("key.keyboard." + name.toLowerCase()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (key == null && name.toLowerCase().startsWith("mouse")) {
            try {
                int button = Integer.parseInt(name.substring(5));
                return class_3675.class_307.field_1672.method_1447(button - 1);
            }
            catch (Exception e) {
                LOGGER.warn("Invalid key definition: {}", (Object)name);
            }
        }
        return key;
    }
}

