/*
 * Decompiled with CFR 0.152.
 */
package com.github.prohect.alias;

import com.github.prohect.alias.AliasWithArgs;
import com.github.prohect.alias.AliasWithoutArgs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public interface Alias<T extends Alias<T>> {
    public static final List<Alias<?>> blackList4lockCursor = new ArrayList();
    public static final HashMap<String, AliasWithoutArgs<?>> aliasesWithoutArgs = new HashMap();
    public static final HashMap<String, AliasWithoutArgs<?>> aliasesWithoutArgs_fromBindCommand = new HashMap();
    public static final HashMap<String, AliasWithArgs<?>> aliasesWithArgs = new HashMap();
    public static final HashMap<String, AliasWithArgs<?>> aliasesWithArgs_notSuggested = new HashMap();
    public static final char divider4AliasDefinition = ' ';
    public static final char divider4AliasArgs = '\\';

    public static String getOppositeDefinition(String args) {
        StringBuilder oppositeDefinition = new StringBuilder();
        ArrayList<String> definitions = Alias.getDefinitions(args);
        definitions.forEach(definition -> {
            if (definition.startsWith("+")) {
                oppositeDefinition.append("-").append(definition.substring(1)).append(' ');
            } else if (definition.startsWith("-")) {
                oppositeDefinition.append("+").append(definition.substring(1)).append(' ');
            }
        });
        return oppositeDefinition.toString();
    }

    @NotNull
    public static ArrayList<String> getDefinitions(String args) {
        ArrayList<String> definitions = new ArrayList<String>();
        StringBuilder currentDefinition = new StringBuilder();
        boolean coveredByDoubleQuotes = false;
        boolean lastStepSubmit = false;
        for (char c : args.toCharArray()) {
            if (c != ' ') {
                if (c == '\"') {
                    coveredByDoubleQuotes = !coveredByDoubleQuotes;
                } else {
                    currentDefinition.append(c);
                }
                lastStepSubmit = false;
                continue;
            }
            if (coveredByDoubleQuotes) {
                currentDefinition.append(c);
                continue;
            }
            if (lastStepSubmit) continue;
            definitions.add(currentDefinition.toString());
            currentDefinition = new StringBuilder();
            lastStepSubmit = true;
        }
        if (!currentDefinition.isEmpty()) {
            definitions.add(currentDefinition.toString());
        }
        return definitions;
    }

    @NotNull
    public static ArrayList<String> getDefinitionSplits(String definition) {
        ArrayList<String> definitionSplits = new ArrayList<String>();
        StringBuilder currentDefinition = new StringBuilder();
        boolean coveredByDoubleQuotes = false;
        boolean lastStepSubmit = false;
        for (char c : definition.toCharArray()) {
            if (c != '\\') {
                if (c == '\"') {
                    coveredByDoubleQuotes = !coveredByDoubleQuotes;
                } else {
                    currentDefinition.append(c);
                }
                lastStepSubmit = false;
                continue;
            }
            if (coveredByDoubleQuotes) {
                currentDefinition.append(c);
                continue;
            }
            if (lastStepSubmit) continue;
            definitionSplits.add(currentDefinition.toString());
            currentDefinition = new StringBuilder();
            lastStepSubmit = true;
        }
        if (!currentDefinition.isEmpty()) {
            definitionSplits.add(currentDefinition.toString());
        }
        return definitionSplits;
    }

    public T run(String var1);

    default public T addToLockCursorBlackList() {
        blackList4lockCursor.add(this);
        return (T)this;
    }
}

