/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.item;

import java.util.List;
import net.knifick.praporupdate.init.PraporModItems;
import net.knifick.praporupdate.item.BetterMaceItem;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BetterMaceChargedItem
extends BetterMaceItem {
    private static final double BEAM_LENGTH = 12.0;
    private static final double BEAM_RADIUS = 5.0;
    private static final float BEAM_DAMAGE = 6.0f;
    private static final double KNOCKBACK = 2.0;

    public BetterMaceChargedItem() {
        super(new Item.Properties().rarity(Rarity.EPIC).durability(500).component(DataComponents.TOOL, (Object)BetterMaceChargedItem.createToolProperties()).attributes(BetterMaceChargedItem.createAttributes()));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        InteractionResultHolder re = super.use(level, player, hand);
        Vec3 eyePos = player.getEyePosition();
        Vec3 dir = player.getViewVector(1.0f).normalize();
        Vec3 endPos = eyePos.add(dir.scale(12.0));
        AABB beamAabb = new AABB(eyePos, endPos).inflate(5.0);
        List targets = level.getEntitiesOfClass(LivingEntity.class, beamAabb, e -> e != player && !e.isInvulnerable());
        for (LivingEntity target : targets) {
            Vec3 p = target.position().subtract(eyePos);
            double t = Mth.clamp((double)p.dot(dir), (double)0.0, (double)12.0);
            Vec3 closest = eyePos.add(dir.scale(t));
            double dist2 = target.position().distanceToSqr(closest);
            if (!(dist2 <= 25.0)) continue;
            DamageSource source = level.damageSources().indirectMagic((Entity)player, (Entity)player);
            target.hurt(source, 6.0f);
            Vec3 knockVec = target.position().subtract(closest).normalize().scale(2.0);
            target.push(knockVec.x, knockVec.y + 0.1, knockVec.z);
        }
        Vec3 direction = player.getViewVector(1.0f).scale(-0.7);
        player.addDeltaMovement(direction);
        int slot = player.getInventory().selected;
        ItemStack weapon = player.getWeaponItem();
        ItemStack newWeapon = new ItemStack((ItemLike)PraporModItems.BETTER_MACE.get());
        newWeapon.setDamageValue(weapon.getDamageValue() + 1);
        if (slot >= 0) {
            player.getInventory().setItem(slot, newWeapon);
        }
        level.playSound(null, player.blockPosition(), SoundEvents.EVOKER_CAST_SPELL, SoundSource.PLAYERS, 1.0f, 1.0f);
        level.playSound(null, player.blockPosition(), SoundEvents.WARDEN_SONIC_BOOM, SoundSource.PLAYERS, 1.0f, 1.0f);
        double step = 0.25;
        double radius = 5.0;
        double halfSize = radius * 0.35;
        if (!level.isClientSide && level instanceof ServerLevel) {
            ServerLevel level_ = (ServerLevel)level;
            for (double d = 0.0; d <= 12.0; d += step) {
                Vec3 pos = eyePos.add(dir.scale(d));
                double offX = (level.random.nextDouble() - 0.5) * halfSize * 2.0;
                double offY = (level.random.nextDouble() - 0.5) * halfSize * 2.0;
                double offZ = (level.random.nextDouble() - 0.5) * halfSize * 2.0;
                level_.sendParticles((ParticleOptions)ParticleTypes.SOUL, pos.x + offX, pos.y + offY, pos.z + offZ, 1, 0.0, 0.0, 0.0, 0.0);
                level_.sendParticles((ParticleOptions)ParticleTypes.SONIC_BOOM, pos.x + offX, pos.y + offY, pos.z + offZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        player.getCooldowns().addCooldown((Item)PraporModItems.BETTER_MACE_CHARGED.get(), 15);
        return re;
    }
}

