/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.procedures;

import java.util.Map;
import net.knifick.praporupdate.entity.NarratorEntity;
import net.knifick.praporupdate.init.PraporModItems;
import net.knifick.praporupdate.init.PraporModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NarratorToAdoptProcedure {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Map<Item, Holder.Reference<SoundEvent>> musics = Map.ofEntries(Map.entry(Items.MUSIC_DISC_13, SoundEvents.MUSIC_DISC_13), Map.entry(Items.MUSIC_DISC_CAT, SoundEvents.MUSIC_DISC_CAT), Map.entry(Items.MUSIC_DISC_BLOCKS, SoundEvents.MUSIC_DISC_BLOCKS), Map.entry(Items.MUSIC_DISC_CHIRP, SoundEvents.MUSIC_DISC_CHIRP), Map.entry(Items.MUSIC_DISC_FAR, SoundEvents.MUSIC_DISC_FAR), Map.entry(Items.MUSIC_DISC_MALL, SoundEvents.MUSIC_DISC_MALL), Map.entry(Items.MUSIC_DISC_MELLOHI, SoundEvents.MUSIC_DISC_MELLOHI), Map.entry(Items.MUSIC_DISC_STAL, SoundEvents.MUSIC_DISC_STAL), Map.entry(Items.MUSIC_DISC_STRAD, SoundEvents.MUSIC_DISC_STRAD), Map.entry(Items.MUSIC_DISC_WARD, SoundEvents.MUSIC_DISC_WARD), Map.entry(Items.MUSIC_DISC_11, SoundEvents.MUSIC_DISC_11), Map.entry(Items.MUSIC_DISC_CREATOR_MUSIC_BOX, SoundEvents.MUSIC_DISC_CREATOR_MUSIC_BOX), Map.entry(Items.MUSIC_DISC_WAIT, SoundEvents.MUSIC_DISC_WAIT), Map.entry(Items.MUSIC_DISC_CREATOR, SoundEvents.MUSIC_DISC_CREATOR), Map.entry(Items.MUSIC_DISC_PRECIPICE, SoundEvents.MUSIC_DISC_PRECIPICE), Map.entry(Items.MUSIC_DISC_OTHERSIDE, SoundEvents.MUSIC_DISC_OTHERSIDE), Map.entry(Items.MUSIC_DISC_RELIC, SoundEvents.MUSIC_DISC_RELIC), Map.entry(Items.MUSIC_DISC_5, SoundEvents.MUSIC_DISC_5), Map.entry(Items.MUSIC_DISC_PIGSTEP, SoundEvents.MUSIC_DISC_PIGSTEP));

    public static boolean isMusicDisc(ItemStack stack) {
        return !stack.isEmpty() && stack.is(Tags.Items.MUSIC_DISCS) || stack.getItem() == PraporModItems.MUSIC_RECORD_N_42.get() || stack.getItem() == PraporModItems.MUSIC_RECORD_THANKS_STREET.get();
    }

    public static boolean isDiscHave(LivingEntity entity) {
        return entity != null && NarratorToAdoptProcedure.isMusicDisc(entity.getItemInHand(InteractionHand.MAIN_HAND));
    }

    private static void playServerSound(Level level, Entity entity, SoundEvent sound, SoundSource source, float volume, float pitch) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (ServerPlayer player : serverLevel.players()) {
            if (!(player.distanceToSqr(entity) < 65536.0)) continue;
            player.connection.send((Packet)new ClientboundSoundPacket(Holder.direct((Object)sound), source, entity.getX(), entity.getY(), entity.getZ(), volume, pitch, serverLevel.getRandom().nextLong()));
        }
    }

    public static void stopServerSound(ServerLevel serverLevel, ResourceLocation soundId, SoundSource source) {
        for (ServerPlayer player : serverLevel.players()) {
            player.connection.send((Packet)new ClientboundStopSoundPacket(soundId, source));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity, Entity sourceentity, ItemStack itemstack) {
        NarratorEntity livingEntity;
        NarratorEntity narrator;
        TamableAnimal _tamEnt;
        if (entity == null) return;
        if (sourceentity == null) {
            return;
        }
        if (!(entity instanceof TamableAnimal) || !(_tamEnt = (TamableAnimal)entity).isTame()) {
            ItemStack itemStack;
            if (sourceentity instanceof LivingEntity) {
                LivingEntity _livEnt = (LivingEntity)sourceentity;
                itemStack = _livEnt.getMainHandItem();
            } else {
                itemStack = ItemStack.EMPTY;
            }
            if (itemStack.getItem() == PraporModItems.BOARD.get()) {
                Level _level;
                if (world instanceof Level && !(_level = (Level)world).isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"prapor:adopt")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                if (entity instanceof TamableAnimal) {
                    TamableAnimal _toTame = (TamableAnimal)entity;
                    if (sourceentity instanceof Player) {
                        Player _owner = (Player)sourceentity;
                        _toTame.tame(_owner);
                    }
                }
                itemstack.shrink(1);
                return;
            }
        }
        if (itemstack.getItem() == PraporModItems.BATTERY.get() && entity instanceof NarratorEntity && !(narrator = (NarratorEntity)entity).isPowered()) {
            if (world.isClientSide()) return;
            narrator.setPowerTimer(72000);
            narrator.setPowered(true);
            narrator.setAnimation("BatteryEnd");
            itemstack.shrink(1);
            return;
        }
        if (NarratorToAdoptProcedure.isMusicDisc(itemstack) && entity instanceof NarratorEntity && !NarratorToAdoptProcedure.isDiscHave((LivingEntity)(livingEntity = (NarratorEntity)entity)) && livingEntity.isTame() && livingEntity.isPowered()) {
            if (world.isClientSide()) return;
            world.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)PraporModSounds.PLUH.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            ItemStack copy = itemstack.copy();
            copy.setCount(1);
            livingEntity.setItemInHand(InteractionHand.MAIN_HAND, copy);
            livingEntity.setMusicPos(livingEntity.blockPosition());
            livingEntity.setMusic(true);
            livingEntity.setAnimation("empty");
            if (itemstack.getItem() != Items.MUSIC_DISC_11 && itemstack.getItem() != Items.MUSIC_DISC_5 && itemstack.getItem() != Items.MUSIC_DISC_13) {
                livingEntity.setAnimation("music");
            } else {
                livingEntity.setAnimation("11");
            }
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                SoundEvent sound = null;
                if (itemstack.is(Tags.Items.MUSIC_DISCS)) {
                    sound = (SoundEvent)musics.get(itemstack.getItem()).value();
                } else if (itemstack.getItem() == PraporModItems.MUSIC_RECORD_N_42.get()) {
                    sound = (SoundEvent)PraporModSounds.SOUND_TRACK.get();
                } else if (itemstack.getItem() == PraporModItems.MUSIC_RECORD_THANKS_STREET.get()) {
                    // empty if block
                }
                if (sound != null) {
                    NarratorToAdoptProcedure.playServerSound((Level)serverLevel, (Entity)livingEntity, sound, SoundSource.RECORDS, 4.0f, 1.0f);
                }
            }
            itemstack.shrink(1);
            return;
        }
        if (!(entity instanceof NarratorEntity)) return;
        NarratorEntity livingEntity2 = (NarratorEntity)entity;
        if (!NarratorToAdoptProcedure.isDiscHave((LivingEntity)livingEntity2)) return;
        if (world.isClientSide()) return;
        livingEntity2.setMusic(false);
        livingEntity2.setAnimation("forced_empty");
        livingEntity2.setAnimation("empty");
        ItemStack extractedDisc = livingEntity2.getItemInHand(InteractionHand.MAIN_HAND).copy();
        livingEntity2.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        double xr = RandomSource.create().nextDouble() * 0.2 - 0.1;
        double zr = RandomSource.create().nextDouble() * 0.2 - 0.1;
        ItemEntity item = new ItemEntity((Level)world, livingEntity2.getX(), livingEntity2.getY() + 0.5, livingEntity2.getZ(), extractedDisc);
        item.setDeltaMovement(new Vec3(xr, 0.3, zr));
        world.addFreshEntity((Entity)item);
        if (!(world instanceof ServerLevel)) return;
        ServerLevel serverLevel = (ServerLevel)world;
        ResourceLocation soundId = null;
        if (extractedDisc.is(Tags.Items.MUSIC_DISCS)) {
            soundId = ((SoundEvent)musics.get(extractedDisc.getItem()).value()).getLocation();
        } else if (extractedDisc.getItem() == PraporModItems.MUSIC_RECORD_N_42.get()) {
            soundId = ((SoundEvent)PraporModSounds.SOUND_TRACK.get()).getLocation();
        } else if (extractedDisc.getItem() == PraporModItems.MUSIC_RECORD_THANKS_STREET.get()) {
            // empty if block
        }
        if (soundId == null) return;
        NarratorToAdoptProcedure.stopServerSound(serverLevel, soundId, SoundSource.RECORDS);
    }
}

