/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.knifick.praporupdate.entity.NarratorEntity;
import net.knifick.praporupdate.entity.model.NarratorModel;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class NarratorRenderer
extends GeoEntityRenderer<NarratorEntity> {
    private static final ResourceLocation NARRATOR_OLD_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"textures/entities/narator_reanimated.png");

    public NarratorRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new NarratorModel());
        this.shadowRadius = 0.8f;
    }

    public RenderType getRenderType(NarratorEntity animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(animatable));
    }

    public ResourceLocation getTextureLocation(NarratorEntity entity) {
        String s = ChatFormatting.stripFormatting((String)entity.getName().getString());
        if ("Boombox".equals(s)) {
            return NARRATOR_OLD_LOCATION;
        }
        return ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)("textures/entities/" + entity.getTexture() + ".png"));
    }

    public void preRender(PoseStack poseStack, NarratorEntity entity, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        float scale;
        this.scaleHeight = scale = 1.0f;
        this.scaleWidth = scale;
        super.preRender(poseStack, (Entity)entity, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }
}

