/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.knifick.praporupdate.entity.SuckerEntity;
import net.knifick.praporupdate.entity.model.SuckerModel;
import net.knifick.praporupdate.procedures.PraporEntityVisualScaleProcedure;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.util.Color;

public class SuckerRenderer
extends GeoEntityRenderer<SuckerEntity> {
    public SuckerRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new SuckerModel());
        this.shadowRadius = 0.5f;
    }

    public RenderType getRenderType(SuckerEntity animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation((Entity)animatable));
    }

    public void preRender(PoseStack poseStack, SuckerEntity entity, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        float scale;
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        this.scaleHeight = scale = (float)PraporEntityVisualScaleProcedure.execute((Entity)entity);
        this.scaleWidth = scale;
        super.preRender(poseStack, (Entity)entity, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }

    protected float getDeathMaxRotation(SuckerEntity entityLivingBaseIn) {
        return 90.0f;
    }

    public void renderRecursively(PoseStack poseStack, SuckerEntity animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        if ("Eyes".equalsIgnoreCase(bone.getName()) || "Core".equalsIgnoreCase(bone.getName())) {
            super.renderRecursively(poseStack, (Entity)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, -1);
        } else {
            super.renderRecursively(poseStack, (Entity)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        }
    }

    public Color getRenderColor(SuckerEntity animatable, float partialTick, int packedLight) {
        int color = animatable.getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return Color.ofRGBA((float)r, (float)g, (float)b, (float)1.0f);
    }
}

