/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import net.knifick.praporupdate.init.PraporModItems;
import net.knifick.praporupdate.init.PraporModKeyMappings;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class MantleActivateOverlay {
    private static int ticksSinceEquip = -1;

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        boolean hasMantle = player.getInventory().getItem(38).is(PraporModItems.MANTLE);
        ticksSinceEquip = hasMantle ? (ticksSinceEquip < 0 ? 0 : ++ticksSinceEquip) : -1;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void eventHandler(RenderGuiEvent.Pre event) {
        if (ticksSinceEquip < 0 || ticksSinceEquip > 40) {
            return;
        }
        int w = event.getGuiGraphics().guiWidth();
        int h = event.getGuiGraphics().guiHeight();
        Font font = Minecraft.getInstance().font;
        LocalPlayer entity = Minecraft.getInstance().player;
        if (entity == null) {
            return;
        }
        MutableComponent text = Component.translatable((String)"screen.prapor.mantle1");
        MutableComponent textAfter = Component.translatable((String)"screen.prapor.mantle2");
        KeyMapping key = PraporModKeyMappings.MANTLE_KEYBIND;
        String keyName = key.getTranslatedKeyMessage().getString();
        String fullText = text.getString() + keyName + textAfter.getString();
        int fullWidth = font.width(fullText);
        int x = (w - fullWidth) / 2;
        int y = (int)((double)h * 0.8);
        float alpha = 1.0f;
        if (ticksSinceEquip > 20) {
            alpha = 1.0f - (float)(ticksSinceEquip - 20) / 20.0f;
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        event.getGuiGraphics().drawString(font, fullText, x, y, 0xFFFFFF, true);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

