/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.entity;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.knifick.praporupdate.init.PraporModParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class KillCloud
extends Entity {
    public static final EntityDataAccessor<Optional<UUID>> FILTER_UUID = SynchedEntityData.defineId(KillCloud.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(KillCloud.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private float radius = 1.0f;
    private int duration = 200;

    public KillCloud(EntityType<?> type, Level level) {
        super(type, level);
        this.noPhysics = true;
    }

    public void setPlayerUUID(@Nullable UUID player) {
        this.entityData.set(FILTER_UUID, Optional.ofNullable(player));
    }

    @Nullable
    public UUID getPlayerUUID() {
        return ((Optional)this.entityData.get(FILTER_UUID)).orElse(null);
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(FILTER_UUID, Optional.empty());
        builder.define(VARIANT, (Object)0);
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        if (this.getPlayerUUID() != null) {
            tag.putUUID("player_uuid", this.getPlayerUUID());
        }
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("player_uuid")) {
            this.setPlayerUUID(tag.getUUID("player_uuid"));
        }
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.sendParticles((ParticleOptions)((SimpleParticleType)PraporModParticleTypes.EYES.get()), this.getX(), this.getY() + 0.3, this.getZ(), 6, (double)this.radius, 0.0, (double)this.radius, 0.0);
        }
    }

    public void tick() {
        Level level;
        super.tick();
        if (this.tickCount >= this.duration) {
            this.discard();
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (this.tickCount <= this.duration - 180) {
                level2.sendParticles((ParticleOptions)((SimpleParticleType)PraporModParticleTypes.KILL_CLOUD.get()), this.getX(), this.getY() + 0.1, this.getZ(), 4, (double)this.radius, 0.0, (double)this.radius, 0.0);
            }
            AABB box = this.getBoundingBox().inflate((double)this.radius * 2.2, 0.1, (double)this.radius * 2.2);
            List players = level2.getEntitiesOfClass(LivingEntity.class, box);
            DamageSource mantleSource = new DamageSource(this.level().holderOrThrow(ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)"prapor:mantle_hurt"))));
            for (LivingEntity player : players) {
                if (player.getUUID().equals(this.getPlayerUUID())) continue;
                float damage = this.getDamage(player);
                player.hurt(mantleSource, damage);
            }
        }
    }

    private float getDamage(LivingEntity entity) {
        float damage = 0.2f;
        if (this.getVariant() == 1) {
            damage = Math.min(5.0f / entity.getMaxHealth(), 1.0f);
        } else if (this.getVariant() == 2) {
            damage = Math.min(entity.getMaxHealth() / 200.0f, 0.4f);
        }
        return damage;
    }
}

