/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.entity;

import net.knifick.praporupdate.init.PraporModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MunchsawEntity
extends Monster
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(MunchsawEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(MunchsawEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(MunchsawEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> SAW = SynchedEntityData.defineId(MunchsawEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public Vec3 playerPos;
    public String animationprocedure = "empty";

    public MunchsawEntity(EntityType<MunchsawEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT, (Object)false);
        builder.define(ANIMATION, (Object)"undefined");
        builder.define(TEXTURE, (Object)"munchsaw");
        builder.define(SAW, (Object)false);
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    public boolean isSaw() {
        return (Boolean)this.entityData.get(SAW);
    }

    public void setSaw(boolean is) {
        this.entityData.set(SAW, (Object)is);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new SmoothSwimRandomGoal(this, this));
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float f) {
        return super.getPassengerAttachmentPoint(entity, dimensions, f).add(0.0, (double)-0.1f, 0.0);
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"prapor:sucker_idle"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"prapor:sucker_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"prapor:sucker_hurt"));
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.FALL)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    protected PathNavigation createNavigation(Level world) {
        AmphibiousPathNavigation nav = new AmphibiousPathNavigation((Mob)this, world);
        nav.setCanFloat(true);
        return nav;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
        compound.putBoolean("saw", ((Boolean)this.entityData.get(SAW)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
        if (compound.contains("saw")) {
            this.entityData.set(SAW, (Object)compound.getBoolean("saw"));
        }
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.0f);
    }

    public void aiStep() {
        super.aiStep();
        if (this.isInWaterOrBubble()) {
            this.setAirSupply(300);
        }
        this.updateSwingTime();
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)PraporModEntities.PRAPOR.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getFluidState(pos).is((Fluid)Fluids.WATER) && world.getRawBrightness(pos, 0) <= 8, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.45);
        builder = builder.add(Attributes.MAX_HEALTH, 20.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.1);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.3);
        return builder;
    }

    private <E extends GeoAnimatable> PlayState movementPredicate(AnimationState<E> state) {
        if (this.isInWaterOrBubble()) {
            return state.setAndContinue(RawAnimation.begin().thenLoop("swim"));
        }
        if (this.isSprinting() || this.isAggressive() && state.isMoving()) {
            return state.setAndContinue(RawAnimation.begin().thenLoop("run"));
        }
        if (!(!state.isMoving() && state.getLimbSwingAmount() >= -0.1f && state.getLimbSwingAmount() <= 0.1f || !this.onGround() || this.isAggressive() || this.isSprinting())) {
            return state.setAndContinue(RawAnimation.begin().thenLoop("walk"));
        }
        return state.setAndContinue(RawAnimation.begin().thenLoop("idle"));
    }

    private <E extends GeoAnimatable> PlayState attackPredicate(AnimationState<E> state) {
        if (this.swinging) {
            state.getController().forceAnimationReset();
            return state.setAndContinue(RawAnimation.begin().thenPlay("attack"));
        }
        return PlayState.STOP;
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.triggerAnim("triggers", animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "move", 5, this::movementPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attack", 0, this::attackPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "triggers", 0, s -> PlayState.STOP).triggerableAnim("dance", RawAnimation.begin().thenPlay("dance")));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    class SmoothSwimRandomGoal
    extends Goal {
        private final MunchsawEntity mob;
        private Vec3 targetPos;
        private int cooldown;

        public SmoothSwimRandomGoal(MunchsawEntity this$0, MunchsawEntity mob) {
            this.mob = mob;
        }

        public boolean canUse() {
            return this.mob.isInWaterOrBubble();
        }

        public void start() {
            this.pickNewTarget();
        }

        public void tick() {
            if (this.targetPos == null || this.cooldown-- <= 0 || this.mob.position().distanceTo(this.targetPos) < 1.0) {
                this.pickNewTarget();
            }
            if (this.targetPos != null) {
                Level level = this.mob.level();
                if (level instanceof ServerLevel) {
                    ServerLevel level2 = (ServerLevel)level;
                    level2.sendParticles((ParticleOptions)ParticleTypes.FLAME, this.targetPos.x, this.targetPos.y, this.targetPos.z, 1, 0.0, 0.0, 0.0, 0.0);
                }
                Vec3 dir = this.targetPos.subtract(this.mob.position()).normalize().scale(0.05);
                Vec3 newMotion = this.mob.getDeltaMovement().add(dir).scale(0.9);
                this.mob.setDeltaMovement(newMotion);
                Vec3 motion = this.mob.getDeltaMovement();
                if (motion.lengthSqr() > 0.001) {
                    this.mob.setYRot((float)(Mth.atan2((double)motion.z, (double)motion.x) * 57.29577951308232) - 90.0f);
                    this.mob.yBodyRot = this.mob.getYRot();
                    this.mob.yHeadRot = this.mob.getYRot();
                }
            } else {
                this.mob.setDeltaMovement(this.mob.getDeltaMovement().multiply(0.8, 0.0, 0.8));
            }
        }

        private void pickNewTarget() {
            RandomSource rnd = this.mob.getRandom();
            double dx = rnd.nextDouble() * 8.0 - 4.0;
            double dy = rnd.nextDouble() * 4.0 - 2.0;
            double dz = rnd.nextDouble() * 8.0 - 4.0;
            Vec3 pos = new Vec3(this.mob.getX() + dx, this.mob.getY() + dy, this.mob.getZ() + dz);
            if (this.mob.level().getFluidState(this.mob.blockPosition()).is((Fluid)Fluids.WATER) && this.mob.level().getFluidState(new BlockPos((int)pos.x, (int)pos.y, (int)pos.z)).is((Fluid)Fluids.WATER)) {
                this.targetPos = pos;
                this.cooldown = 100 + rnd.nextInt(100);
            } else {
                this.targetPos = null;
            }
        }
    }
}

