/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.entity.model;

import net.knifick.praporupdate.entity.NymphEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class NymphModel
extends GeoModel<NymphEntity> {
    public ResourceLocation getAnimationResource(NymphEntity entity) {
        return ResourceLocation.parse((String)"prapor:animations/nymph.animation.json");
    }

    public ResourceLocation getModelResource(NymphEntity entity) {
        return ResourceLocation.parse((String)"prapor:geo/nymph.geo.json");
    }

    public ResourceLocation getTextureResource(NymphEntity entity) {
        return ResourceLocation.parse((String)("prapor:textures/entities/" + entity.getTexture() + ".png"));
    }

    public void setCustomAnimations(NymphEntity animatable, long instanceId, AnimationState animationState) {
        GeoBone head = this.getAnimationProcessor().getBone("Head");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
        GeoBone tail1 = this.getAnimationProcessor().getBone("t1");
        GeoBone tail2 = this.getAnimationProcessor().getBone("t2");
        GeoBone tail3 = this.getAnimationProcessor().getBone("t3");
        GeoBone tail4 = this.getAnimationProcessor().getBone("t4");
        GeoBone tail5 = this.getAnimationProcessor().getBone("t5");
        float ageInTicks = (float)animatable.tickCount + animationState.getPartialTick();
        float speed = (float)animatable.getDeltaMovement().length();
        float motionY = (float)animatable.getDeltaMovement().y;
        float targetPitch = motionY * 0.5f;
        float smoothFactor = 0.1f;
        if (tail1 != null) {
            tail1.setRotX(tail1.getRotX() + (targetPitch - tail1.getRotX()) * smoothFactor);
        }
        if (tail2 != null) {
            tail2.setRotX(tail2.getRotX() + (targetPitch - tail2.getRotX()) * smoothFactor);
        }
        if (tail3 != null) {
            tail3.setRotX(tail3.getRotX() + (targetPitch - tail3.getRotX()) * smoothFactor);
        }
        if (tail4 != null) {
            tail4.setRotX(tail4.getRotX() + (targetPitch - tail4.getRotX()) * smoothFactor);
        }
        if (tail5 != null) {
            tail5.setRotX(tail5.getRotX() + (targetPitch - tail5.getRotX()) * smoothFactor);
        }
        float baseAmplitude = 0.01f;
        float waveSpeed = 0.2f;
        if (tail1 != null) {
            tail1.setRotX(tail1.getRotX() + (float)Math.sin(ageInTicks * waveSpeed + 1.0f) * baseAmplitude);
        }
        if (tail2 != null) {
            tail2.setRotX(tail2.getRotX() + (float)Math.sin(ageInTicks * waveSpeed + 1.4f) * baseAmplitude);
        }
        if (tail3 != null) {
            tail3.setRotX(tail3.getRotX() + (float)Math.sin(ageInTicks * waveSpeed + 1.9f) * baseAmplitude);
        }
        if (tail4 != null) {
            tail4.setRotX(tail4.getRotX() + (float)Math.sin(ageInTicks * waveSpeed + 2.4f) * baseAmplitude);
        }
        if (tail5 != null) {
            tail5.setRotX(tail5.getRotX() + (float)Math.sin(ageInTicks * waveSpeed + 2.8f) * baseAmplitude);
        }
    }
}

