/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.event.effect;

import net.knifick.praporupdate.init.PraporModMobEffects;
import net.minecraft.client.Minecraft;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;

@EventBusSubscriber(modid="prapor", bus=EventBusSubscriber.Bus.GAME)
public class PulseEffectHandler {
    private static final float SPEED = 1.0f;
    private static final float FADE_SPEED = 1.0f;
    private static long startTime = System.nanoTime();
    private static float pulseAlpha = 0.0f;
    private static boolean fadingOut = false;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRenderOverlay(RenderGuiLayerEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        boolean hasFearEffect = mc.player.hasEffect(PraporModMobEffects.FEAR);
        if (hasFearEffect) {
            long currentTime = System.nanoTime();
            float elapsedSeconds = (float)(currentTime - startTime) / 1.0E9f;
            pulseAlpha = (float)(0.5 + 0.5 * Math.sin((double)elapsedSeconds * Math.PI * 1.0));
            fadingOut = false;
        } else {
            if (!fadingOut) {
                fadingOut = true;
                startTime = System.nanoTime();
            }
            pulseAlpha = Math.max(0.0f, pulseAlpha - 1.0f);
        }
        if (pulseAlpha > 0.0f) {
            event.getGuiGraphics().fillGradient(0, 0, mc.getWindow().getGuiScaledWidth(), (int)((double)mc.getWindow().getGuiScaledHeight() / 1.5), (int)(pulseAlpha * 200.0f) << 24, 0);
        }
    }
}

