/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.event.mantle;

import java.util.Random;
import net.knifick.praporupdate.entity.KillCloud;
import net.knifick.praporupdate.init.PraporModEntities;
import net.knifick.praporupdate.init.PraporModItems;
import net.knifick.praporupdate.init.PraporModParticleTypes;
import net.knifick.praporupdate.init.PraporModSounds;
import net.knifick.praporupdate.network.PraporModVariables;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber
public class MantleTrigger {
    private static final int MAX_TIME = 10;
    private static final int COOLDOWN = 60;
    private static Vec3 direction = Vec3.ZERO;
    private static int variant = 0;

    @SubscribeEvent
    public static void PlayerPerTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        PraporModVariables.PlayerVariables vars = (PraporModVariables.PlayerVariables)player.getData(PraporModVariables.PLAYER_VARIABLES);
        if (vars.mantleTimer > 0) {
            ++vars.mantleTimer;
            vars.syncPlayerVariables((Entity)player);
            if (vars.mantleTimer < 9) {
                player.setDeltaMovement(direction.scale((double)(10 - vars.mantleTimer) / 3.0));
            }
            player.hurtMarked = true;
            player.setNoGravity(true);
            KillCloud killCloud = new KillCloud((EntityType)PraporModEntities.KILL_CLOUD.get(), player.level());
            killCloud.setPos(player.position());
            player.level().addFreshEntity((Entity)killCloud);
            killCloud.setPlayerUUID(player.getUUID());
            killCloud.setVariant(variant);
            Level level = player.level();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.sendParticles((ParticleOptions)((SimpleParticleType)PraporModParticleTypes.EYES.get()), player.getX(), player.getY() + 1.0, player.getZ(), 5, 1.0, 1.0, 1.0, 0.0);
            }
        }
        if (vars.mantleTimer >= 10) {
            player.setNoGravity(false);
            vars.mantleTimer = 0;
            vars.syncPlayerVariables((Entity)player);
        }
    }

    public static void onItemUse(Player player) {
        ItemStack itemStack = player.getInventory().getItem(38);
        if (itemStack.is(PraporModItems.MANTLE)) {
            PraporModVariables.PlayerVariables vars = (PraporModVariables.PlayerVariables)player.getData(PraporModVariables.PLAYER_VARIABLES);
            if (vars.mantleTimer == 0 && !player.getCooldowns().isOnCooldown((Item)PraporModItems.MANTLE.get())) {
                Level level;
                direction = player.getViewVector(0.0f);
                variant = new Random().nextInt(0, 3);
                vars.mantleTimer = 1;
                vars.syncPlayerVariables((Entity)player);
                player.getCooldowns().addCooldown((Item)PraporModItems.MANTLE.get(), 70);
                if (!player.isCreative()) {
                    itemStack.setDamageValue(itemStack.getDamageValue() + 1);
                }
                System.out.println(itemStack.getDamageValue());
                if (itemStack.getDamageValue() == 10) {
                    player.playSound(SoundEvents.ITEM_BREAK);
                    player.getInventory().setItem(38, ItemStack.EMPTY);
                }
                if ((level = player.level()) instanceof ServerLevel) {
                    ServerLevel level2 = (ServerLevel)level;
                    level2.playSound(null, player.blockPosition(), (SoundEvent)PraporModSounds.MANTLE_USE.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                    level2.playSound(null, player.blockPosition(), SoundEvents.ALLAY_AMBIENT_WITHOUT_ITEM, SoundSource.AMBIENT, 5.0f, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            PraporModVariables.PlayerVariables vars = (PraporModVariables.PlayerVariables)player.getData(PraporModVariables.PLAYER_VARIABLES);
            if (vars.mantleTimer > 0) {
                player.playSound(SoundEvents.ANVIL_LAND, 5.0f, 1.0f);
                event.setCanceled(true);
            }
        }
    }
}

