/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.event.sucker;

import java.util.UUID;
import net.knifick.praporupdate.entity.SuckerEntity;
import net.knifick.praporupdate.init.PraporModEntities;
import net.knifick.praporupdate.init.PraporModSounds;
import net.knifick.praporupdate.network.PraporModVariables;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber
public class TossHandler {
    @SubscribeEvent
    public static void onItemToss(ItemTossEvent event) {
        Player player = event.getPlayer();
        Level level = player.level();
        if (!level.isClientSide && level.dimension() == Level.END) {
            ItemEntity itemEntity = event.getEntity();
            CompoundTag data = itemEntity.getPersistentData();
            data.putUUID("OwnerUUID", player.getUUID());
            data.putDouble("OwnerX", player.getX());
            data.putDouble("OwnerY", player.getY());
            data.putDouble("OwnerZ", player.getZ());
        }
    }

    @SubscribeEvent
    public static void onItemTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity entity2 = (ItemEntity)entity;
        CompoundTag data = entity2.getPersistentData();
        if (data.contains("unsuck_timer")) {
            data.putDouble("unsuck_timer", data.getDouble("unsuck_timer") + 1.0);
            if (data.getDouble("unsuck_timer") >= 60.0) {
                data.remove("unsuck_timer");
            }
        }
        if (entity2.getY() < 0.0) {
            if (!data.hasUUID("OwnerUUID")) {
                return;
            }
            UUID ownerId = data.getUUID("OwnerUUID");
            Vec3 ownerPos = new Vec3(data.getDouble("OwnerX"), data.getDouble("OwnerY"), data.getDouble("OwnerZ"));
            if (ownerId != null) {
                ServerPlayer owner = (ServerPlayer)entity2.level().getPlayerByUUID(ownerId);
                if (owner == null) {
                    return;
                }
                PraporModVariables.PlayerVariables vars = (PraporModVariables.PlayerVariables)owner.getData(PraporModVariables.PLAYER_VARIABLES);
                if (!vars.hasSucker) {
                    SuckerEntity sucker = (SuckerEntity)((EntityType)PraporModEntities.SUCKER.get()).create(entity2.level());
                    entity2.playSound((SoundEvent)PraporModSounds.SUCKER_APPROACH.get(), 49.0f, 1.0f);
                    if (sucker != null) {
                        sucker.moveTo(entity2.getX(), entity2.getY(), entity2.getZ(), owner.getYRot(), owner.getXRot());
                        sucker.inventory.setItem(0, entity2.getItem());
                        owner.level().addFreshEntity((Entity)sucker);
                        sucker.playerPos = ownerPos;
                        sucker.setPlayerUUID(ownerId);
                        vars.hasSucker = true;
                        vars.syncPlayerVariables((Entity)owner);
                    }
                    entity2.discard();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onSuckerTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof SuckerEntity)) {
            return;
        }
        SuckerEntity entity2 = (SuckerEntity)entity;
        Level level = entity2.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        MinecraftServer server = serverLevel.getServer();
        if (server == null) {
            return;
        }
        UUID playerUUID = entity2.getPlayerUUID();
        if (playerUUID == null) {
            return;
        }
        ServerPlayer owner = server.getPlayerList().getPlayer(playerUUID);
        if (owner == null) {
            return;
        }
        if (entity2.getOwner() != null) {
            return;
        }
        Vec3 ownerPos = entity2.playerPos;
        Vec3 entityPos = entity2.position();
        Vec3 direction = ownerPos.subtract(entityPos);
        double distance = direction.length();
        if (distance > 0.1 && entity2.tickCount < 100) {
            Vec3 movement = direction.normalize().scale(0.6).add(0.0, 0.3, 0.0);
            entity2.setDeltaMovement(movement);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, entityPos.x, entityPos.y, entityPos.z, 1, 0.2, 0.2, 0.2, 0.05);
        } else {
            CompoundTag data = entity2.getPersistentData();
            data.putUUID("SuckerUUID", owner.getUUID());
            entity2.tame((Player)owner);
            entity2.setPlayerUUID(null);
            entity2.setDeltaMovement(Vec3.ZERO);
        }
    }
}

