/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.procedures;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.knifick.praporupdate.PraporMod;
import net.knifick.praporupdate.entity.DarkironkinEntity;
import net.knifick.praporupdate.util.ironkin.ScreenShakeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DarkironkinOnRMCProcedure {
    private static final int GR_TIMER_TICKS = 100;
    private static final int GR_SWITCH_TICKS = 78;
    private static final int SM_SWITCH_TICKS = 84;
    private static final int PARTICLE_COUNT = 900;
    private static final double PARTICLE_RADIUS = 20.0;
    private static final double PARTICLE_Y_BASE = 0.1;
    private static final double PARTICLE_Y_RAND = 0.15;
    private static final double ATTACK_RADIUS = 20.0;
    private static final double KNOCK_Y_STRONG = 0.8;
    private static final double KNOCK_Y_MED = 0.6;
    private static final double KNOCK_Y_LIGHT = 0.4;
    private static final double KNOCK_Y_TINY = 0.2;
    private static final double R1 = 6.0;
    private static final double R1_2 = 36.0;
    private static final double R2 = 10.0;
    private static final double R2_2 = 100.0;
    private static final double R3 = 14.0;
    private static final double R3_2 = 196.0;
    private static final double R4 = 20.0;
    private static final double R4_2 = 400.0;
    private static final float DMG_R1 = 20.0f;
    private static final float DMG_R2 = 16.0f;
    private static final float DMG_R3 = 12.0f;
    private static final float DMG_R4 = 8.0f;
    private static final int SLOW_R1_T = 300;
    private static final int SLOW_R1_A = 2;
    private static final int SLOW_R2_T = 200;
    private static final int SLOW_R2_A = 2;
    private static final int SLOW_R3_T = 150;
    private static final int SLOW_R3_A = 1;
    private static final int SLOW_R4_T = 100;
    private static final int SLOW_R4_A = 1;
    private static final ResourceLocation DS_ID = ResourceLocation.parse((String)"prapor:darkironkinhurt");
    private static final ResourceLocation SND_GROUND = ResourceLocation.parse((String)"prapor:ironkin_ground_hit");
    private static final ResourceLocation SND_SUMMON = ResourceLocation.parse((String)"prapor:summon");

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (!(entity instanceof Mob)) {
            return;
        }
        if (DarkironkinOnRMCProcedure.canGroundAttack(entity)) {
            DarkironkinOnRMCProcedure.startGroundAttack(entity);
            PraporMod.queueServerWork(27, () -> {
                DarkironkinOnRMCProcedure.playSound(world, x, y, z, SND_GROUND, SoundSource.HOSTILE);
                DarkironkinOnRMCProcedure.spawnGroundParticles(world, x, z);
                DarkironkinOnRMCProcedure.doGroundShockwave(world, x, y, z, entity);
            });
            return;
        }
        if (DarkironkinOnRMCProcedure.canSummon(entity)) {
            DarkironkinOnRMCProcedure.startSummon(entity);
            PraporMod.queueServerWork(42, () -> {
                DarkironkinOnRMCProcedure.playSound(world, x, y, z, ResourceLocation.parse((String)"event.raid.horn"), SoundSource.NEUTRAL);
                DarkironkinOnRMCProcedure.playSound(world, x, y, z, SND_SUMMON, SoundSource.NEUTRAL);
                DarkironkinOnRMCProcedure.spawnWitherSkeletonsAround((LivingEntity)entity, 8, 5, 15);
            });
        }
    }

    private static boolean canGroundAttack(Entity e) {
        if (!(e instanceof DarkironkinEntity)) {
            return false;
        }
        DarkironkinEntity d = (DarkironkinEntity)e;
        if (((Boolean)d.getEntityData().get(DarkironkinEntity.DATA_IsGrAttack)).booleanValue()) {
            return false;
        }
        if (((Boolean)d.getEntityData().get(DarkironkinEntity.DATA_IsSmAttack)).booleanValue()) {
            return false;
        }
        return (Integer)d.getEntityData().get(DarkironkinEntity.DATA_GrTimer) == 0;
    }

    private static void startGroundAttack(Entity e) {
        DarkironkinEntity d = (DarkironkinEntity)e;
        d.getEntityData().set(DarkironkinEntity.DATA_GrTimer, (Object)100);
        d.getEntityData().set(DarkironkinEntity.DATA_IsGrAttack, (Object)true);
        d.getEntityData().set(DarkironkinEntity.DATA_GrSwitchTimer, (Object)78);
        d.setAnimation("groundHit");
    }

    private static void spawnGroundParticles(LevelAccessor world, double x, double z) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)world;
        RandomSource rnd = RandomSource.create();
        HashMap<BlockPos, Integer> heightCache = new HashMap<BlockPos, Integer>();
        for (int i = 0; i < 900; ++i) {
            double angle = rnd.nextDouble() * (Math.PI * 2);
            double dist = rnd.nextDouble() * 20.0;
            double px = x + (double)Mth.cos((float)((float)angle)) * dist;
            double pz = z + (double)Mth.sin((float)((float)angle)) * dist;
            BlockPos col = BlockPos.containing((double)px, (double)0.0, (double)pz);
            int surfaceY = heightCache.computeIfAbsent(col, p -> world.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, p.getX(), p.getZ()));
            double py = (double)surfaceY + 0.1 + rnd.nextDouble() * 0.15;
            double fx = (double)col.getX() + rnd.nextDouble();
            double fz = (double)col.getZ() + rnd.nextDouble();
            server.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, fx, py, fz, 1, 0.0, 0.05, 0.0, 0.01);
        }
    }

    private static void doGroundShockwave(LevelAccessor world, double x, double y, double z, Entity source) {
        AABB box = AABB.ofSize((Vec3)new Vec3(x, y, z), (double)40.0, (double)40.0, (double)40.0);
        List victims = world.getEntitiesOfClass(LivingEntity.class, box, e -> DarkironkinOnRMCProcedure.isValidTarget(e, source));
        if (victims.isEmpty()) {
            return;
        }
        DamageSource ds = new DamageSource(world.holderOrThrow(ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)DS_ID)));
        LivingEntity closest = Collections.min(victims, Comparator.comparingDouble(e -> e.distanceToSqr(x, y, z)));
        double d2closest = closest.distanceToSqr(x, y, z);
        if (d2closest <= 36.0) {
            ScreenShakeUtil.startShake(20, 20.0f);
        } else if (d2closest <= 100.0) {
            ScreenShakeUtil.startShake(20, 15.0f);
        } else if (d2closest <= 196.0) {
            ScreenShakeUtil.startShake(20, 10.0f);
        } else if (d2closest <= 400.0) {
            ScreenShakeUtil.startShake(20, 8.0f);
        }
        for (LivingEntity le : victims) {
            if (le.level().isClientSide()) continue;
            double d2 = le.distanceToSqr(x, y, z);
            if (d2 <= 36.0) {
                DarkironkinOnRMCProcedure.applyHit(le, ds, 20.0f, 300, 2, 0.8);
                continue;
            }
            if (d2 <= 100.0) {
                DarkironkinOnRMCProcedure.applyHit(le, ds, 16.0f, 200, 2, 0.6);
                continue;
            }
            if (d2 <= 196.0) {
                DarkironkinOnRMCProcedure.applyHit(le, ds, 12.0f, 150, 1, 0.4);
                continue;
            }
            if (!(d2 <= 400.0)) continue;
            DarkironkinOnRMCProcedure.applyHit(le, ds, 8.0f, 100, 1, 0.2);
        }
    }

    private static boolean isValidTarget(LivingEntity e, Entity source) {
        if (e == source) {
            return false;
        }
        if (e instanceof DarkironkinEntity) {
            return false;
        }
        return !(e instanceof WitherSkeleton);
    }

    private static void applyHit(LivingEntity target, DamageSource ds, float damage, int slowTicks, int slowAmplifier, double knockY) {
        target.hurt(ds, damage);
        target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, slowTicks, slowAmplifier, true, false));
        target.push(0.0, knockY, 0.0);
    }

    private static boolean canSummon(Entity e) {
        LivingEntity le;
        if (!(e instanceof DarkironkinEntity)) {
            return false;
        }
        DarkironkinEntity d = (DarkironkinEntity)e;
        if (((Boolean)d.getEntityData().get(DarkironkinEntity.DATA_IsSmAttack)).booleanValue()) {
            return false;
        }
        if (((Boolean)d.getEntityData().get(DarkironkinEntity.DATA_IsGrAttack)).booleanValue()) {
            return false;
        }
        if (((Boolean)d.getEntityData().get(DarkironkinEntity.DATA_SmSwitcher)).booleanValue()) {
            return false;
        }
        return e instanceof LivingEntity && (le = (LivingEntity)e).getHealth() <= 40.0f;
    }

    private static void startSummon(Entity e) {
        DarkironkinEntity d = (DarkironkinEntity)e;
        d.setAnimation("summon");
        d.getEntityData().set(DarkironkinEntity.DATA_IsSmAttack, (Object)true);
        d.getEntityData().set(DarkironkinEntity.DATA_SmSwitchTimer, (Object)84);
    }

    private static void spawnWitherSkeletonsAround(LivingEntity caster, int radius, int count, int maxAttempts) {
        Level lvl = caster.level();
        if (lvl.isClientSide) {
            return;
        }
        RandomSource rnd = RandomSource.create();
        for (int i = 0; i < count; ++i) {
            int attempts = 0;
            boolean spawned = false;
            block1: while (attempts++ < maxAttempts && !spawned) {
                double angle = rnd.nextDouble() * Math.PI * 2.0;
                double dist = rnd.nextDouble() * (double)radius;
                double xd = caster.getX() + Math.cos(angle) * dist;
                double zd = caster.getZ() + Math.sin(angle) * dist;
                for (int yd = lvl.getMaxBuildHeight(); yd >= lvl.getMinBuildHeight(); --yd) {
                    BlockPos pos = new BlockPos((int)xd, yd, (int)zd);
                    BlockState below = lvl.getBlockState(pos.below());
                    if (!below.isSolid()) continue;
                    WitherSkeleton sk = new WitherSkeleton(EntityType.WITHER_SKELETON, lvl);
                    sk.setPos(xd + 0.5, (double)yd, zd + 0.5);
                    if (!lvl.noCollision((Entity)sk)) continue;
                    lvl.addFreshEntity((Entity)sk);
                    if (lvl instanceof ServerLevel) {
                        ServerLevel sl = (ServerLevel)lvl;
                        sl.sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, xd + 0.5, (double)(yd + 1), zd + 0.5, 200, 0.5, 1.0, 0.5, 0.01);
                    }
                    spawned = true;
                    continue block1;
                }
            }
        }
    }

    private static void playSound(LevelAccessor world, double x, double y, double z, ResourceLocation id, SoundSource src) {
        if (!(world instanceof Level)) {
            return;
        }
        Level lvl = (Level)world;
        if (!lvl.isClientSide()) {
            lvl.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(id), src, 1.0f, 1.0f);
        } else {
            lvl.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(id), src, 1.0f, 1.0f, false);
        }
    }
}

