/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.procedures;

import net.knifick.praporupdate.PraporMod;
import net.knifick.praporupdate.init.PraporModMobEffects;
import net.knifick.praporupdate.init.PraporModSounds;
import net.knifick.praporupdate.network.PraporModVariables;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelAccessor;

public class FrameReturnerProcedure {
    private static final int MAX_FRAME = 10;
    private static final int TICK_DELAY = 2;

    public static void execute(LevelAccessor world, Entity entity, double duration) {
        if (entity == null) {
            return;
        }
        PraporModVariables.PlayerVariables vars = (PraporModVariables.PlayerVariables)entity.getData(PraporModVariables.PLAYER_VARIABLES);
        if (vars.screamAnimValue == 0.0) {
            FrameReturnerProcedure.playScreamSound(world, entity);
            FrameReturnerProcedure.applyFearEffect(entity, duration);
            FrameReturnerProcedure.startAnimation(entity);
        } else {
            FrameReturnerProcedure.resetAnimation(entity);
        }
    }

    private static void playScreamSound(LevelAccessor world, Entity entity) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            serverLevel.playSound(null, entity.blockPosition(), (SoundEvent)PraporModSounds.SCREAM.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        }
    }

    private static void applyFearEffect(Entity entity, double duration) {
        LivingEntity living;
        if (entity instanceof LivingEntity && !(living = (LivingEntity)entity).level().isClientSide()) {
            living.addEffect(new MobEffectInstance(PraporModMobEffects.FEAR, (int)duration, 0, true, false));
        }
    }

    private static void startAnimation(Entity entity) {
        for (int frame = 1; frame <= 10; ++frame) {
            int currentFrame = frame;
            PraporMod.queueServerWork(frame * 2, () -> FrameReturnerProcedure.setAnimValue(entity, currentFrame));
        }
        PraporMod.queueServerWork(22, () -> FrameReturnerProcedure.setAnimValue(entity, 0));
    }

    private static void resetAnimation(Entity entity) {
        FrameReturnerProcedure.setAnimValue(entity, 0);
    }

    private static void setAnimValue(Entity entity, int value) {
        PraporModVariables.PlayerVariables vars = (PraporModVariables.PlayerVariables)entity.getData(PraporModVariables.PLAYER_VARIABLES);
        vars.screamAnimValue = value;
        vars.syncPlayerVariables(entity);
    }
}

