/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.client.effects;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3fc;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME, modid="prapor")
public class RingSuckEffectD {
    private static final ResourceLocation SPRITE_SHEET = ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"textures/mob_effect/suck_ring.png");
    private static final float MAX_LIFETIME = 10.0f;
    private static final List<Wave> waves = new CopyOnWriteArrayList<Wave>();
    private static final int FRAME_COUNT = 8;
    private static final int FRAME_TIME = 1;

    public static void trigger(double x, double y, double z, double dx, double dy, double dz) {
        double modifier = 0.05;
        waves.add(new Wave(x, y, z, dx, dy, dz));
    }

    @SubscribeEvent
    public static void onRender(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        float partialTicks = event.getPartialTick().getGameTimeDeltaPartialTick(true);
        PoseStack pose = event.getPoseStack();
        Camera camera = event.getCamera();
        Vec3 camPos = camera.getPosition();
        for (Wave wave : waves) {
            float gameTime = (float)Minecraft.getInstance().level.getGameTime() + event.getPartialTick().getGameTimeDeltaPartialTick(true);
            wave.age = gameTime - (float)wave.spawnTick;
            if (wave.age > 10.0f) {
                waves.remove(wave);
                continue;
            }
            RingSuckEffectD.renderAnimatedQuad(pose, camPos, wave, partialTicks);
        }
    }

    private static void renderAnimatedQuad(PoseStack poseStack, Vec3 cam, Wave wave, float partialTicks) {
        float alpha;
        float size;
        poseStack.pushPose();
        long gameTime = Minecraft.getInstance().level.getGameTime();
        int frame = (int)(gameTime / 1L % 8L);
        float t = (wave.age + partialTicks) / 10.0f;
        if (t > 1.0f) {
            t = 1.0f;
        }
        Vec3 dir = new Vec3(wave.dx - wave.x, wave.dy - wave.y, wave.dz - wave.z).normalize();
        double offset = 0.3;
        double startX = wave.x + dir.x * offset;
        double startY = wave.y + dir.y * offset;
        double startZ = wave.z + dir.z * offset;
        double cx = Mth.lerp((double)t, (double)startX, (double)wave.dx);
        double cy = Mth.lerp((double)t, (double)startY, (double)wave.dy);
        double cz = Mth.lerp((double)t, (double)startZ, (double)wave.dz);
        poseStack.translate(-cam.x, -cam.y, -cam.z);
        poseStack.translate(cx, cy + 0.7, cz);
        Vec3 forward = new Vec3(0.0, 1.0, 0.0);
        float dot = (float)forward.dot(dir);
        dot = Mth.clamp((float)dot, (float)-1.0f, (float)1.0f);
        float angle = (float)Math.acos(dot);
        Vec3 axis = forward.cross(dir).normalize();
        Quaternionf q = axis.lengthSqr() < 1.0E-6 ? new Quaternionf().rotationY(dot > 0.0f ? 0.0f : (float)Math.PI) : new Quaternionf().fromAxisAngleRad((Vector3fc)axis.toVector3f(), angle);
        poseStack.mulPose(q);
        float baseSize = 4.0f;
        float minSize = 0.0f;
        float growTime = 6.0f;
        if (wave.age < growTime) {
            float progress = (wave.age + partialTicks) / growTime;
            size = Mth.lerp((float)progress, (float)minSize, (float)baseSize);
        } else {
            size = baseSize;
        }
        poseStack.scale(size, size, size);
        float fadeStart = 5.0f;
        if (wave.age < fadeStart) {
            alpha = 1.0f;
        } else {
            float fadeProgress = (wave.age - fadeStart) / (10.0f - fadeStart);
            alpha = 1.0f - fadeProgress;
            if (alpha < 0.0f) {
                alpha = 0.0f;
            }
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.disableCull();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SPRITE_SHEET);
        RenderSystem.applyModelViewMatrix();
        float vSize = 0.125f;
        float u0 = 0.0f;
        float u1 = 1.0f;
        float v0 = (float)frame * vSize;
        float v1 = v0 + vSize;
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder buf = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        Matrix4f m = poseStack.last().pose();
        float s = 0.5f;
        buf.addVertex(m, -s, 0.0f, -s).setUv(u0, v1).setColor(1.0f, 1.0f, 1.0f, alpha);
        buf.addVertex(m, s, 0.0f, -s).setUv(u1, v1).setColor(1.0f, 1.0f, 1.0f, alpha);
        buf.addVertex(m, s, 0.0f, s).setUv(u1, v0).setColor(1.0f, 1.0f, 1.0f, alpha);
        buf.addVertex(m, -s, 0.0f, s).setUv(u0, v0).setColor(1.0f, 1.0f, 1.0f, alpha);
        BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    private static class Wave {
        final double x;
        final double y;
        final double z;
        final double dx;
        final double dy;
        final double dz;
        float age;
        long spawnTick;
        final float travelTime = 20.0f;

        Wave(double x, double y, double z, double dx, double dy, double dz) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.dx = dx;
            this.dy = dy;
            this.dz = dz;
            this.spawnTick = Minecraft.getInstance().level.getGameTime();
        }
    }
}

