/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.knifick.praporupdate.entity.SoulEntity;
import net.knifick.praporupdate.init.PraporModEntities;
import net.knifick.praporupdate.network.PraporModVariables;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BookScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"textures/screens/guide_bg.png");
    private static final ResourceLocation BG_FILL = ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"textures/screens/guide_fill.png");
    private static final ResourceLocation UNKNOWN = ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"textures/screens/guide_unknown.png");
    private static final ResourceLocation ARROWS = ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"textures/screens/guide_arrows.png");
    private static final List<ResourceLocation> PAGES = List.of(ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"textures/screens/p1.png"), ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"textures/screens/p2.png"), ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"textures/screens/p3.png"));
    private static final List<MobEntry> MOB_ENTRIES = List.of(new MobEntry("prapor", -40, -20, 30, () -> (LivingEntity)((EntityType)PraporModEntities.PRAPOR.get()).create((Level)Minecraft.getInstance().level), (Component)Component.translatable((String)"entity.prapor.prapor"), List.of(Component.translatable((String)"guide.prapor.prapor"), Component.translatable((String)"guide.prapor.addprapor"))), new MobEntry("pooker", 30, -10, 20, () -> (LivingEntity)((EntityType)PraporModEntities.POOKER.get()).create((Level)Minecraft.getInstance().level), (Component)Component.translatable((String)"entity.prapor.pooker"), List.of(Component.translatable((String)"guide.prapor.pooker"), Component.translatable((String)"guide.prapor.addpooker"))), new MobEntry("soul", -40, -20, 70, () -> (LivingEntity)((EntityType)PraporModEntities.SOUL.get()).create((Level)Minecraft.getInstance().level), (Component)Component.translatable((String)"entity.prapor.soul"), List.of(Component.translatable((String)"guide.prapor.soul"))), new MobEntry("bastard", 30, -22, 30, () -> (LivingEntity)((EntityType)PraporModEntities.BASTARD.get()).create((Level)Minecraft.getInstance().level), (Component)Component.translatable((String)"entity.prapor.bastard"), List.of(Component.translatable((String)"guide.prapor.bastard"), Component.translatable((String)"guide.prapor.addbastard"))), new MobEntry("narrator", -30, -20, 40, () -> (LivingEntity)((EntityType)PraporModEntities.NARRATOR.get()).create((Level)Minecraft.getInstance().level), (Component)Component.translatable((String)"entity.prapor.narrator"), List.of(Component.translatable((String)"guide.prapor.narrator"), Component.translatable((String)"guide.prapor.addnarrator"), Component.translatable((String)"guide.prapor.thirdnarrator"))), new MobEntry("brolem", 30, -22, 20, () -> (LivingEntity)((EntityType)PraporModEntities.BROLEM.get()).create((Level)Minecraft.getInstance().level), (Component)Component.translatable((String)"entity.prapor.brolem"), List.of(Component.translatable((String)"guide.prapor.brolem"), Component.translatable((String)"guide.prapor.addbrolem"))), new MobEntry("bob", -30, -20, 40, () -> (LivingEntity)((EntityType)PraporModEntities.BOB.get()).create((Level)Minecraft.getInstance().level), (Component)Component.translatable((String)"entity.prapor.bob"), List.of(Component.translatable((String)"guide.prapor.bob"), Component.translatable((String)"guide.prapor.abob").withStyle(ChatFormatting.ITALIC), Component.translatable((String)"guide.prapor.bbob").withStyle(ChatFormatting.BOLD))), new MobEntry("darkironkin", 40, -18, 15, () -> (LivingEntity)((EntityType)PraporModEntities.DARKIRONKIN.get()).create((Level)Minecraft.getInstance().level), (Component)Component.translatable((String)"entity.prapor.darkironkin"), List.of(Component.translatable((String)"guide.prapor.darkironkin"), Component.translatable((String)"guide.prapor.adddarkironkin"))), new MobEntry("nymph", -20, -20, 30, () -> (LivingEntity)((EntityType)PraporModEntities.NYMPH.get()).create((Level)Minecraft.getInstance().level), (Component)Component.translatable((String)"entity.prapor.nymph"), List.of(Component.translatable((String)"guide.prapor.nymph"), Component.translatable((String)"guide.prapor.addnymph"))), new MobEntry("sucker", 30, -22, 30, () -> (LivingEntity)((EntityType)PraporModEntities.SUCKER.get()).create((Level)Minecraft.getInstance().level), (Component)Component.translatable((String)"entity.prapor.sucker"), List.of(Component.translatable((String)"guide.prapor.sucker"))));
    private static List<Integer> additionList = new ArrayList<Integer>();
    private int pageIndex = 0;
    private static final int ENTRIES_PER_PAGE = 2;

    public BookScreen(Component title) {
        super(title);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int pageSide;
        MobEntry entry;
        int idx;
        int i;
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        PraporModVariables.PlayerVariables vars = (PraporModVariables.PlayerVariables)Minecraft.getInstance().player.getData(PraporModVariables.PLAYER_VARIABLES);
        boolean hasWrites = vars.seenMobs.values().stream().anyMatch(v -> v != 0);
        if (!hasWrites) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.1f);
        }
        int pageInnerHalf = 60;
        int pageCenterY = this.height / 2;
        int startIndex = this.pageIndex * 2;
        block0: for (i = 0; i < 2; ++i) {
            for (int x = 0; x < PAGES.size(); ++x) {
                boolean seen;
                idx = startIndex + i;
                entry = MOB_ENTRIES.get(idx);
                if (vars.seenMobs.get(entry.key) - 1 < x) continue block0;
                pageSide = i;
                int tabStartX = this.width / 2 - 20 + (pageSide == 0 ? -60 : 79);
                int tabY = this.height / 2 - 110;
                ResourceLocation tabTexture = PAGES.get(x);
                int idi = idx + x;
                if (additionList.get(idx) == x) {
                    tabY -= 9;
                }
                boolean bl = seen = vars.seenMobs.getOrDefault(entry.key, 0) != 0;
                if (!seen) continue;
                guiGraphics.blit(tabTexture, tabStartX + x * 25, tabY, 0.0f, 0.0f, 23, 30, 23, 30);
            }
        }
        guiGraphics.blit(BACKGROUND, this.width / 2 - 142, this.height / 2 - 90, 0.0f, 0.0f, 285, 180, 285, 180);
        for (i = 0; i < 2; ++i) {
            ResourceLocation BG_FILL;
            int pageSide2 = i;
            idx = startIndex + i;
            if (additionList.get(idx) == 1 && pageSide2 == 0) {
                BG_FILL = ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"textures/screens/guide_bg2.png");
                guiGraphics.blit(BG_FILL, this.width / 2 - 142, this.height / 2 - 90, 0.0f, 0.0f, 142, 180, 142, 180);
            }
            if (additionList.get(idx) == 2 && pageSide2 == 0) {
                BG_FILL = ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"textures/screens/guide_bg3.png");
                guiGraphics.blit(BG_FILL, this.width / 2 - 142, this.height / 2 - 90, 0.0f, 0.0f, 142, 180, 142, 180);
            }
            if (additionList.get(idx) == 1 && pageSide2 == 1) {
                BG_FILL = ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"textures/screens/guide_flip_bg2.png");
                guiGraphics.blit(BG_FILL, this.width / 2, this.height / 2 - 90, 0.0f, 0.0f, 143, 180, 143, 180);
            }
            if (additionList.get(idx) != 2 || pageSide2 != 1) continue;
            BG_FILL = ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"textures/screens/guide_flip_bg3.png");
            guiGraphics.blit(BG_FILL, this.width / 2, this.height / 2 - 90, 0.0f, 0.0f, 142, 180, 142, 180);
        }
        float follow = 0.005f;
        for (int i2 = 0; i2 < 2 && (idx = startIndex + i2) < MOB_ENTRIES.size(); ++i2) {
            boolean seen;
            entry = MOB_ENTRIES.get(idx);
            pageSide = i2;
            int pageCenterX = this.width / 2 + (pageSide == 0 ? -60 : 60);
            int drawX = pageCenterX + entry.offsetX;
            int drawY = pageCenterY + entry.offsetY;
            boolean bl = seen = vars.seenMobs.getOrDefault(entry.key, 0) != 0;
            if (!seen) {
                guiGraphics.blit(UNKNOWN, pageSide == 0 ? this.width / 2 - 80 : this.width / 2 + 60, this.height / 2 - 20, 0.0f, 0.0f, 19, 31, 19, 31);
            } else {
                LivingEntity entity = entry.entitySupplier.get();
                if (entity != null) {
                    float angleX = Mth.clamp((float)((float)(drawX - mouseX) * follow), (float)-2.0f, (float)2.0f);
                    float angleY = Mth.clamp((float)((float)(drawY - mouseY) * follow), (float)-0.5f, (float)0.5f);
                    if (entity instanceof SoulEntity) {
                        angleX -= 4.5f;
                    }
                    this.renderEntityInInventoryFollowsAngle(guiGraphics, drawX, drawY, entry.scale, angleX, angleY, entity);
                }
            }
            int mobStage = vars.seenMobs.getOrDefault(entry.key, 0);
            if (mobStage <= 0) continue;
            int addIndex = additionList.get(idx);
            if (addIndex >= entry.descriptions.size()) {
                addIndex = entry.descriptions.size() - 1;
            }
            Component mainDesc = entry.descriptions.get(addIndex);
            int textX = pageSide == 0 ? this.width / 2 - 120 : this.width / 2 + 10;
            int textY = this.height / 2 - 70;
            this.renderDescriptionsWithPriority(guiGraphics, entry.title, mainDesc, mobStage, textX, textY, 110, 150, pageSide);
        }
        Font font = Minecraft.getInstance().font;
        int arrowY = this.height / 2 + 70;
        int leftArrowX = this.width / 2 - 115;
        int rightArrowX = this.width / 2 + 100;
        int totalPages = (MOB_ENTRIES.size() + 2 - 1) / 2;
        boolean hoverLeft = mouseX >= leftArrowX && mouseX <= leftArrowX + 17 && mouseY >= arrowY && mouseY <= arrowY + 13;
        boolean hoverRight = mouseX >= rightArrowX && mouseX <= rightArrowX + 23 && mouseY >= arrowY && mouseY <= arrowY + 13;
        guiGraphics.blit(ARROWS, leftArrowX, arrowY, hoverLeft ? 18.0f : 0.0f, 13.0f, 18, 10, 36, 23);
        guiGraphics.blit(ARROWS, rightArrowX, arrowY, hoverRight ? 18.0f : 0.0f, 0.0f, 18, 10, 36, 23);
        String pageIndicator = String.format("%d / %d", this.pageIndex + 1, Math.max(totalPages, 1));
        guiGraphics.drawString(font, (Component)Component.literal((String)pageIndicator), this.width / 2 - font.width((FormattedText)Component.literal((String)pageIndicator)) / 2, arrowY + 25, 0xFFFFFF, false);
        if (!hasWrites) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            guiGraphics.drawString(font, (Component)Component.translatable((String)"guide.prapor.guide1"), this.width / 2 - 89, this.height / 2 - 50, 0xFFFFFF, false);
            guiGraphics.drawString(font, (Component)Component.translatable((String)"guide.prapor.guide2"), this.width / 2 - 80, this.height / 2 - 40, 0xFFFFFF, false);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int arrowY = this.height / 2 + 70;
        int leftArrowX = this.width / 2 - 120;
        int rightArrowX = this.width / 2 + 100;
        int pageY = this.height / 2 - 110;
        int pageX = this.width / 2 - 79;
        int totalPages = (MOB_ENTRIES.size() + 2 - 1) / 2;
        if (mouseX >= (double)leftArrowX && mouseX <= (double)(leftArrowX + 23) && mouseY >= (double)arrowY && mouseY <= (double)(arrowY + 13) && this.pageIndex > 0) {
            Minecraft.getInstance().player.playSound(SoundEvents.VILLAGER_WORK_LIBRARIAN);
            --this.pageIndex;
            return true;
        }
        if (mouseX >= (double)rightArrowX && mouseX <= (double)(rightArrowX + 23) && mouseY >= (double)arrowY && mouseY <= (double)(arrowY + 13) && this.pageIndex < totalPages - 1) {
            Minecraft.getInstance().player.playSound(SoundEvents.VILLAGER_WORK_LIBRARIAN);
            ++this.pageIndex;
            return true;
        }
        PraporModVariables.PlayerVariables vars = (PraporModVariables.PlayerVariables)Minecraft.getInstance().player.getData(PraporModVariables.PLAYER_VARIABLES);
        int startIndex = this.pageIndex * 2;
        block0: for (int i = 0; i < 2; ++i) {
            for (int x = 0; x < PAGES.size(); ++x) {
                int pageSide = i;
                int idx = startIndex + i;
                if (idx >= MOB_ENTRIES.size()) continue block0;
                MobEntry entry = MOB_ENTRIES.get(idx);
                if (vars.seenMobs.get(entry.key) - 1 < x) continue block0;
                int idi = idx + x;
                int offsetX = x * 25;
                if (pageSide == 1) {
                    offsetX += 139;
                }
                if (!(mouseX >= (double)(pageX + offsetX) && mouseX <= (double)(pageX + 21 + offsetX) && mouseY >= (double)pageY && mouseY <= (double)(pageY + 23) && additionList.get(idx) != x)) continue;
                additionList.set(idx, x);
                Minecraft.getInstance().player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value());
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void renderEntityInInventoryFollowsAngle(GuiGraphics guiGraphics, int x, int y, int scale, float angleXComponent, float angleYComponent, LivingEntity entity) {
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf cameraOrientation = new Quaternionf().rotateX(angleYComponent * 20.0f * ((float)Math.PI / 180));
        pose.mul((Quaternionfc)cameraOrientation);
        float prevBodyRot = entity.yBodyRot;
        float prevYRot = entity.getYRot();
        float prevXRot = entity.getXRot();
        float prevHeadRotO = entity.yHeadRotO;
        float prevHeadRot = entity.yHeadRot;
        entity.yBodyRot = 180.0f + angleXComponent * 20.0f;
        entity.setYRot(180.0f + angleXComponent * 40.0f);
        entity.setXRot(-angleYComponent * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)x, (float)y, (float)scale, (Vector3f)new Vector3f(0.0f, 0.0f, 0.0f), (Quaternionf)pose, (Quaternionf)cameraOrientation, (LivingEntity)entity);
        entity.yBodyRot = prevBodyRot;
        entity.setYRot(prevYRot);
        entity.setXRot(prevXRot);
        entity.yHeadRotO = prevHeadRotO;
        entity.yHeadRot = prevHeadRot;
    }

    private void renderWrappedText(GuiGraphics graphics, Component title, Component text, int x, int y, int maxWidth, int maxHeight, int page) {
        Font font = Minecraft.getInstance().font;
        int nameOffset = 0;
        if (page == 0) {
            nameOffset = 40;
        }
        graphics.drawString(font, title, x + 5 + nameOffset, y, 0x404040, false);
        List lines = font.split((FormattedText)text, maxWidth);
        int lineY = y + 55;
        for (int i = 0; i < lines.size() && lineY < y + maxHeight; lineY += 10, ++i) {
            graphics.drawString(font, (FormattedCharSequence)lines.get(i), x, lineY, 0x202020, false);
        }
    }

    private void renderDescriptionsWithPriority(GuiGraphics graphics, Component title, Component mainDescription, int mobStage, int x, int y, int maxWidth, int maxHeight, int page) {
        Font font = Minecraft.getInstance().font;
        int nameOffset = 0;
        if (page == 0) {
            nameOffset = 40;
        }
        graphics.drawString(font, title, x + 5 + nameOffset, y, 0x404040, false);
        List lines = font.split((FormattedText)mainDescription, maxWidth);
        int lineY = y + 55;
        for (int i = 0; i < lines.size() && lineY < y + maxHeight; lineY += 10, ++i) {
            graphics.drawString(font, (FormattedCharSequence)lines.get(i), x, lineY, 0x202020, false);
        }
    }

    static {
        for (int i = 0; i < MOB_ENTRIES.size(); ++i) {
            additionList.add(0);
        }
    }

    private record MobEntry(String key, int offsetX, int offsetY, int scale, Supplier<LivingEntity> entitySupplier, Component title, List<Component> descriptions) {
    }
}

