/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.goal;

import java.util.EnumSet;
import java.util.Random;
import net.knifick.praporupdate.entity.NarratorEntity;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class NarratorGoal
extends Goal {
    private final NarratorEntity mob;
    private Player targetPlayer;
    private int state = 0;
    private int actionCooldown = 0;
    private final Random random = new Random();
    private int fleeTicks = 0;
    private static final int SOUND_DURATION = 60;

    public NarratorGoal(NarratorEntity mob) {
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.mob.isTame()) {
            return false;
        }
        this.targetPlayer = this.mob.level().getNearestPlayer((Entity)this.mob, 10.0);
        return this.targetPlayer != null && !this.mob.getScaredPlayers().contains(this.targetPlayer.getUUID()) && this.mob.isPowered() && this.mob.hasLineOfSight((Entity)this.targetPlayer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canContinueToUse() {
        if (this.targetPlayer == null) return false;
        if (this.targetPlayer.isRemoved()) return false;
        if (this.mob.isTame()) return false;
        if (!this.mob.isPowered()) return false;
        if (this.state >= 2) {
            if (this.fleeTicks <= 0) return false;
        }
        double d = this.mob.distanceTo((Entity)this.targetPlayer);
        double d2 = this.state == 2 ? 30.0 : 15.0;
        if (!(d < d2)) return false;
        return true;
    }

    public void start() {
        if (this.targetPlayer != null) {
            this.mob.getLookControl().setLookAt((Entity)this.targetPlayer, 30.0f, 30.0f);
        }
        this.state = 0;
        this.actionCooldown = 0;
        this.fleeTicks = 0;
    }

    public void tick() {
        if (this.actionCooldown > 0) {
            --this.actionCooldown;
            return;
        }
        switch (this.state) {
            case 0: {
                this.handleApproach();
                break;
            }
            case 1: {
                this.handleSoundAndScare();
                break;
            }
            case 2: {
                this.handleFlee();
            }
        }
    }

    private void handleApproach() {
        Path path;
        if (this.targetPlayer == null || this.targetPlayer.isRemoved()) {
            this.stop();
            return;
        }
        if ((double)this.mob.distanceTo((Entity)this.targetPlayer) < 2.0) {
            this.state = 1;
            this.actionCooldown = 20;
            return;
        }
        if (this.mob.getNavigation().isDone() && (path = this.mob.getNavigation().createPath((Entity)this.targetPlayer, 0)) != null) {
            this.mob.getNavigation().moveTo(path, 1.2);
        }
    }

    private void handleSoundAndScare() {
        if (this.targetPlayer != null) {
            if (this.mob.getVariant() == 1) {
                this.mob.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"prapor:pleaswwfthenarrator")), 3.0f, 1.0f);
            } else if (this.mob.getVariant() == 2) {
                this.mob.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"prapor:dictor_sound")), 3.0f, 1.0f);
            }
            this.mob.getScaredPlayers().add(this.targetPlayer.getUUID());
        }
        this.grantAdvancement();
        this.state = 2;
        this.actionCooldown = 60;
        this.fleeTicks = 80;
    }

    private void handleFlee() {
        if (this.fleeTicks <= 0) {
            this.stop();
            return;
        }
        this.handleFleeMovement();
        --this.fleeTicks;
    }

    private void grantAdvancement() {
        Player player = this.targetPlayer;
        if (player instanceof ServerPlayer) {
            AdvancementProgress progress;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AdvancementHolder advancement = serverPlayer.server.getAdvancements().get(ResourceLocation.parse((String)"prapor:narator_ach"));
            if (advancement != null && !(progress = serverPlayer.getAdvancements().getOrStartProgress(advancement)).isDone()) {
                progress.getRemainingCriteria().forEach(criterion -> serverPlayer.getAdvancements().award(advancement, criterion));
            }
        }
    }

    private void handleFleeMovement() {
        if (this.mob.getNavigation().isDone() && this.targetPlayer != null) {
            Vec3 awayVector = this.mob.position().subtract(this.targetPlayer.position()).normalize().scale(15.0).add((double)(this.random.nextFloat() * 10.0f - 5.0f), 0.0, (double)(this.random.nextFloat() * 10.0f - 5.0f));
            Path path = this.mob.getNavigation().createPath((double)((int)Math.floor(awayVector.x())), (double)((int)Math.floor(this.mob.getY())), (double)((int)Math.floor(awayVector.z())), 0);
            if (path != null) {
                this.mob.getNavigation().moveTo(path, 2.0);
            }
        }
    }

    public void stop() {
        this.mob.getNavigation().stop();
        this.targetPlayer = null;
        this.state = 0;
        this.fleeTicks = 0;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

