/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.goal;

import java.util.Comparator;
import java.util.List;
import net.knifick.praporupdate.PraporMod;
import net.knifick.praporupdate.entity.SuckerEntity;
import net.knifick.praporupdate.init.PraporModSounds;
import net.knifick.praporupdate.network.payloads.RingSuckPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class SuckerSuckGoal
extends Goal {
    private final SuckerEntity sucker;
    private final double radius;
    private final double pullStrength;
    private ItemEntity targetItem;
    private int timer;

    public SuckerSuckGoal(SuckerEntity sucker, double radius, double pullStrength) {
        this.sucker = sucker;
        this.radius = radius;
        this.pullStrength = pullStrength;
    }

    public boolean canUse() {
        return this.updateTarget() && this.sucker.isSuck();
    }

    public boolean canContinueToUse() {
        return this.isValidTarget(this.targetItem) && this.sucker.isSuck();
    }

    public void start() {
        this.sucker.setTexture("sucker_suck");
        this.sucker.playSound((SoundEvent)PraporModSounds.SUCK.get());
        this.timer = 0;
    }

    public void stop() {
        this.sucker.setTexture("sucker_happy");
        this.targetItem = null;
    }

    public void tick() {
        if (!this.isValidTarget(this.targetItem) && !this.updateTarget()) {
            return;
        }
        ++this.timer;
        if (this.sucker.tickCount % 4 == 0) {
            this.sucker.playSound((SoundEvent)PraporModSounds.SUCK.get());
        }
        this.sucker.getLookControl().setLookAt((Entity)this.targetItem, 180.0f, 360.0f);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new RingSuckPayload(this.sucker.getX(), this.sucker.getY(), this.sucker.getZ(), this.targetItem.getX(), this.targetItem.getY(), this.targetItem.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.pullEntitiesInSight();
        if (this.sucker.distanceToSqr((Entity)this.targetItem) < 9.0) {
            this.sucker.addItemToInventory(this.targetItem.getItem());
            this.targetItem.discard();
        }
    }

    private boolean isValidTarget(ItemEntity item) {
        if (item == null || !item.isAlive() || item.getPersistentData().contains("unsuck_timer")) {
            return false;
        }
        return this.sucker.distanceToSqr((Entity)item) <= this.radius * this.radius;
    }

    private boolean updateTarget() {
        List items = this.sucker.level().getEntitiesOfClass(ItemEntity.class, this.sucker.getBoundingBox().inflate(this.radius));
        this.targetItem = items.stream().filter(this::isValidTarget).min(Comparator.comparingDouble(arg_0 -> ((SuckerEntity)this.sucker).distanceToSqr(arg_0))).orElse(null);
        return this.targetItem != null;
    }

    private void pullEntitiesInSight() {
        List entities = this.sucker.level().getEntities((Entity)null, this.sucker.getBoundingBox().inflate(this.radius), e -> e != this.sucker && e.isAlive());
        Vec3 lookVec = this.sucker.getLookAngle().normalize();
        Vec3 eyePos = this.sucker.getEyePosition();
        double fov = Math.cos(Math.toRadians(60.0));
        for (Entity entity : entities) {
            float yOffset;
            Vec3 pull;
            Vec3 toSucker;
            Vec3 toEntity = entity.position().subtract(eyePos).normalize();
            double dot = lookVec.dot(toEntity);
            double angle = Math.toDegrees(Math.acos(dot));
            boolean inSight = dot > fov;
            PraporMod.LOGGER.info("[PullDebug] Target={} | dot={} | angle={}\u00b0 | fov={} | inSight={}", (Object)entity.getName().getString(), (Object)String.format("%.3f", dot), (Object)String.format("%.1f", angle), (Object)String.format("%.3f", fov), (Object)inSight);
            if (entity instanceof ItemEntity) {
                toSucker = this.sucker.position().subtract(entity.position());
                pull = toSucker.normalize().scale(this.pullStrength);
                yOffset = (float)Math.sin((float)entity.tickCount * 0.3f) * 0.1f;
                entity.push(pull.x, pull.y + (double)yOffset, pull.z);
                continue;
            }
            if (!inSight) continue;
            toSucker = this.sucker.position().subtract(entity.position());
            pull = toSucker.normalize().scale(this.pullStrength);
            yOffset = (float)Math.sin((float)entity.tickCount * 0.3f) * 0.1f;
            entity.push(pull.x / 2.0, pull.y / 2.0 + (double)yOffset, pull.z / 2.0);
        }
    }
}

