/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KillCloudParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final float initialSize;

    public static KillParticleProvider provider(SpriteSet spriteSet) {
        return new KillParticleProvider(spriteSet);
    }

    protected KillCloudParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
        super(world, x, y, z, vx, vy, vz);
        float f;
        this.sprites = spriteSet;
        this.initialSize = this.quadSize = 0.25f;
        this.lifetime = 200 + this.random.nextInt(40);
        this.rCol = f = this.random.nextFloat() * 0.3f + 0.6f;
        this.gCol = f;
        this.bCol = f;
        this.gravity = -5.0E-4f;
        this.hasPhysics = true;
        this.xd = vx * 0.1;
        this.yd = vy * 0.1 + 0.02;
        this.zd = vz * 0.1;
        this.setSpriteFromAge(spriteSet);
    }

    public void tick() {
        super.tick();
        if (!this.removed) {
            float progress = (float)this.age / (float)this.lifetime;
            this.quadSize = this.initialSize * (1.0f + progress * 3.0f);
            this.alpha = 1.0f - progress;
            this.setSpriteFromAge(this.sprites);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class KillParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public KillParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new KillCloudParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

