/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.entity;

import java.awt.Color;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.knifick.praporupdate.goal.SuckerSuckGoal;
import net.knifick.praporupdate.init.PraporModEntities;
import net.knifick.praporupdate.network.PraporModVariables;
import net.knifick.praporupdate.procedures.PraporSlowFallingProcedure;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SuckerEntity
extends TamableAnimal
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(SuckerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(SuckerEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(SuckerEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> DATA_isTamed = SynchedEntityData.defineId(SuckerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> IS_SUCK = SynchedEntityData.defineId(SuckerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Optional<UUID>> PLAYER_UUID = SynchedEntityData.defineId(SuckerEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(SuckerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public Vec3 playerPos;
    public String animationprocedure = "empty";
    private static final int MAX_ITEMS = 5;
    private int nextInventoryIndex = 0;
    public final SimpleContainer inventory = new SimpleContainer(5);
    String prevAnim = "empty";

    public SuckerEntity(EntityType<SuckerEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT, (Object)false);
        builder.define(ANIMATION, (Object)"undefined");
        builder.define(TEXTURE, (Object)"sucker_idle");
        builder.define(PLAYER_UUID, Optional.empty());
        builder.define(DATA_isTamed, (Object)false);
        builder.define(COLOR, (Object)-1);
        builder.define(IS_SUCK, (Object)true);
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    public void setPlayerUUID(@Nullable UUID player) {
        this.entityData.set(PLAYER_UUID, Optional.ofNullable(player));
    }

    @Nullable
    public UUID getPlayerUUID() {
        return ((Optional)this.entityData.get(PLAYER_UUID)).orElse(null);
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    public void setColor(int color) {
        this.entityData.set(COLOR, (Object)color);
    }

    public boolean isSuck() {
        return (Boolean)this.entityData.get(IS_SUCK);
    }

    public void setSuck(boolean is) {
        this.entityData.set(IS_SUCK, (Object)is);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new SuckerSuckGoal(this, 10.0, 0.1));
        this.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f){

            public boolean canUse() {
                return super.canUse() && !SuckerEntity.this.getTexture().equals("sucker_suck");
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && !SuckerEntity.this.getTexture().equals("sucker_suck");
            }
        });
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean canUse() {
                return super.canUse() && !SuckerEntity.this.getTexture().equals("sucker_suck");
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && !SuckerEntity.this.getTexture().equals("sucker_suck");
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                return super.canUse() && !SuckerEntity.this.getTexture().equals("sucker_suck");
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && !SuckerEntity.this.getTexture().equals("sucker_suck");
            }
        });
        this.goalSelector.addGoal(5, (Goal)new FloatGoal((Mob)this));
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float f) {
        return super.getPassengerAttachmentPoint(entity, dimensions, f).add(0.0, (double)-0.1f, 0.0);
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"prapor:sucker_idle"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"prapor:sucker_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"prapor:sucker_hurt"));
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.FALL)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
        if (this.getPlayerUUID() != null) {
            compound.putUUID("player_uuid", this.getPlayerUUID());
        }
        compound.putBoolean("DataisTamed", ((Boolean)this.entityData.get(DATA_isTamed)).booleanValue());
        compound.putBoolean("is_suck", ((Boolean)this.entityData.get(IS_SUCK)).booleanValue());
        compound.put("Inventory", (Tag)this.inventory.createTag((HolderLookup.Provider)this.level().registryAccess()));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
        if (compound.contains("DataisTamed")) {
            this.entityData.set(DATA_isTamed, (Object)compound.getBoolean("DataisTamed"));
        }
        if (compound.contains("player_uuid")) {
            this.setPlayerUUID(compound.getUUID("player_uuid"));
        }
        if (compound.contains("is_suck")) {
            this.entityData.set(IS_SUCK, (Object)compound.getBoolean("is_suck"));
        }
        if (compound.contains("Inventory")) {
            this.inventory.fromTag(compound.getList("Inventory", 10), (HolderLookup.Provider)this.level().registryAccess());
        }
    }

    public void addItemToInventory(ItemStack stack) {
        ItemStack slotStack;
        int i;
        ItemStack copy = stack.copy();
        for (i = 0; i < 5; ++i) {
            slotStack = this.inventory.getItem(i);
            if (slotStack.isEmpty() || !ItemStack.isSameItem((ItemStack)slotStack, (ItemStack)copy) || slotStack.getCount() >= slotStack.getMaxStackSize()) continue;
            int spaceLeft = slotStack.getMaxStackSize() - slotStack.getCount();
            int toAdd = Math.min(spaceLeft, copy.getCount());
            slotStack.grow(toAdd);
            copy.shrink(toAdd);
            if (!copy.isEmpty()) continue;
            return;
        }
        for (i = 0; i < 5; ++i) {
            slotStack = this.inventory.getItem(i);
            if (!slotStack.isEmpty()) continue;
            this.inventory.setItem(i, copy);
            return;
        }
        this.inventory.setItem(this.nextInventoryIndex, copy);
        slotStack = this.getOwner();
        if (!(slotStack instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)slotStack;
        PraporModVariables.PlayerVariables vars = (PraporModVariables.PlayerVariables)player.getData(PraporModVariables.PLAYER_VARIABLES);
        vars.suckCount += copy.getCount();
        vars.syncPlayerVariables((Entity)player);
        this.checkAchievement(player);
        this.nextInventoryIndex = (this.nextInventoryIndex + 1) % 5;
    }

    public void checkAchievement(ServerPlayer player) {
        PraporModVariables.PlayerVariables vars = (PraporModVariables.PlayerVariables)player.getData(PraporModVariables.PLAYER_VARIABLES);
        System.out.println(vars.suckCount);
        if (vars.suckCount >= 1000) {
            AdvancementHolder _adv = player.server.getAdvancements().get(ResourceLocation.parse((String)"prapor:mouth_job"));
            AdvancementProgress _ap = player.getAdvancements().getOrStartProgress(_adv);
            if (!_ap.isDone()) {
                for (String criteria : _ap.getRemainingCriteria()) {
                    player.getAdvancements().award(_adv, criteria);
                }
            }
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack toDrop;
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        if (sourceentity.isShiftKeyDown()) {
            this.setSuck(!this.isSuck());
            return retval;
        }
        byte result = this.isCleanItemStack(itemstack);
        if (result != 0 && this.getColor() != -1) {
            this.setColor(-1);
            if (result == 1) {
                this.playSound(SoundEvents.BUCKET_EMPTY);
                for (int i = 0; i < 8; ++i) {
                    double dx = (this.random.nextDouble() - 0.5) * 1.5;
                    double dy = this.random.nextDouble() * 0.5 + 1.5;
                    double dz = (this.random.nextDouble() - 0.5) * 1.5;
                    this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX(), this.getY() + 1.0, this.getZ(), dx, dy, dz);
                }
                if (!sourceentity.getAbilities().instabuild) {
                    sourceentity.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
                }
            } else if (result == 2) {
                this.playSound(SoundEvents.BRUSH_GENERIC);
                for (int i = 0; i < 8; ++i) {
                    double dx = (this.random.nextDouble() - 0.5) * 1.5;
                    double dy = this.random.nextDouble() * 0.5 + 1.5;
                    double dz = (this.random.nextDouble() - 0.5) * 1.5;
                    this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, Blocks.RED_CONCRETE.defaultBlockState()), this.getX(), this.getY() + 1.0, this.getZ(), dx, dy, dz);
                }
                if (!sourceentity.getAbilities().instabuild) {
                    itemstack.setDamageValue(itemstack.getDamageValue() + 1);
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        Item dx = itemstack.getItem();
        if (dx instanceof DyeItem) {
            DyeItem dye = (DyeItem)dx;
            int rgb = dye.getDyeColor().getTextColor();
            this.setColor(rgb);
            this.playSound(SoundEvents.DYE_USE);
            int color = this.getColor();
            double r = (double)(color >> 16 & 0xFF) / 255.0;
            double g = (double)(color >> 8 & 0xFF) / 255.0;
            double b = (double)(color & 0xFF) / 255.0;
            for (int i = 0; i < 8; ++i) {
                double dx2 = (this.random.nextDouble() - 0.5) * 3.5;
                double dy = this.random.nextDouble() * 0.5 + 3.5;
                double dz = (this.random.nextDouble() - 0.5) * 3.5;
                this.level().addParticle((ParticleOptions)new DustParticleOptions(new Vector3f((float)r, (float)g, (float)b), 1.0f), this.getX(), this.getY() + 1.0, this.getZ(), dx2, dy, dz);
            }
            if (!sourceentity.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (!this.level().isClientSide() && this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) && !(toDrop = this.dropLastItem()).isEmpty()) {
            ItemEntity itementity = new ItemEntity(this.level(), this.getX(), this.getY() + 1.0, this.getZ(), toDrop);
            Vec3 motion = new Vec3(sourceentity.getX() - this.getX(), sourceentity.getEyeY() - this.getY(), sourceentity.getZ() - this.getZ()).normalize().scale(0.3);
            itementity.setDeltaMovement(motion);
            this.level().addFreshEntity((Entity)itementity);
            CompoundTag data = itementity.getPersistentData();
            data.putDouble("unsuck_timer", 0.0);
        }
        return retval;
    }

    private byte isCleanItemStack(ItemStack itemStack) {
        int ret = 0;
        if (itemStack.is(Items.WATER_BUCKET)) {
            ret = 1;
        } else if (itemStack.is(Items.BRUSH)) {
            ret = 2;
        }
        return (byte)ret;
    }

    public void baseTick() {
        super.baseTick();
        PraporSlowFallingProcedure.execute((Entity)this);
        if (this.getColor() == 0) {
            double dx = (this.random.nextDouble() - 0.5) * 1.5;
            double dy = (this.random.nextDouble() - 0.5) * 1.5;
            double dz = (this.random.nextDouble() - 0.5) * 1.5;
            this.level().addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.0f), 1.0f), this.getX() + dx, this.getY() + dy + 1.0, this.getZ() + dz, dx, dy, dz);
        }
        if ("jeb_".equals(this.getDisplayName().getString())) {
            float hue = (float)(this.tickCount % 360) / 360.0f;
            int rgb = Color.HSBtoRGB(hue, 1.0f, 1.0f);
            this.setColor(rgb);
        }
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.0f);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        SuckerEntity retval = (SuckerEntity)((EntityType)PraporModEntities.SUCKER.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Objects.equals(Blocks.SAND.asItem(), stack.getItem());
    }

    public void travel(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.getPassengers().isEmpty() ? null : (Entity)this.getPassengers().get(0);
        if (this.isVehicle()) {
            double d0;
            double d1;
            float f1;
            this.setYRot(entity.getYRot());
            this.yRotO = this.getYRot();
            this.setXRot(entity.getXRot() * 0.5f);
            this.setRot(this.getYRot(), this.getXRot());
            this.yBodyRot = entity.getYRot();
            this.yHeadRot = entity.getYRot();
            if (entity instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED));
                float forward = passenger.zza;
                float strafe = passenger.xxa;
                super.travel(new Vec3((double)strafe, 0.0, (double)forward));
            }
            if ((f1 = (float)Math.sqrt((d1 = this.getX() - this.xo) * d1 + (d0 = this.getZ() - this.zo) * d0) * 4.0f) > 1.0f) {
                f1 = 1.0f;
            }
            this.walkAnimation.setSpeed(this.walkAnimation.speed() + (f1 - this.walkAnimation.speed()) * 0.4f);
            this.walkAnimation.position(this.walkAnimation.position() + this.walkAnimation.speed());
            this.calculateEntityAnimation(true);
            return;
        }
        super.travel(dir);
    }

    public void aiStep() {
        super.aiStep();
        this.updateSwingTime();
    }

    public ItemStack dropLastItem() {
        for (int i = 4; i >= 0; --i) {
            ItemStack stack = this.inventory.getItem(i);
            if (stack.isEmpty()) continue;
            this.inventory.setItem(i, ItemStack.EMPTY);
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public void addItem(ItemStack stack) {
        int i;
        ItemStack copy = stack.copy();
        copy.setCount(1);
        for (i = 0; i < 5; ++i) {
            if (!this.inventory.getItem(i).isEmpty()) continue;
            this.inventory.setItem(i, copy);
            return;
        }
        for (i = 1; i < 5; ++i) {
            this.inventory.setItem(i - 1, this.inventory.getItem(i));
        }
        this.inventory.setItem(4, copy);
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)PraporModEntities.PRAPOR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON) && world.getRawBrightness(pos, 0) > 8, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.15);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.9);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.3);
        return builder;
    }

    private <E extends GeoAnimatable> PlayState movementPredicate(AnimationState<E> state) {
        if (this.isSucking()) {
            return PlayState.STOP;
        }
        if (this.isDeadOrDying()) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("death"));
        }
        if (!this.onGround()) {
            return state.setAndContinue(RawAnimation.begin().thenLoop("flight"));
        }
        if (this.isSprinting() || this.isAggressive() && state.isMoving()) {
            return state.setAndContinue(RawAnimation.begin().thenLoop("run"));
        }
        if (!(!state.isMoving() && state.getLimbSwingAmount() >= -0.1f && state.getLimbSwingAmount() <= 0.1f || !this.onGround() || this.isAggressive() || this.isSprinting())) {
            return state.setAndContinue(RawAnimation.begin().thenLoop("walk"));
        }
        return state.setAndContinue(RawAnimation.begin().thenLoop("idle"));
    }

    private boolean isSucking() {
        return "sucker_suck".equals(this.getTexture());
    }

    private <E extends GeoAnimatable> PlayState attackPredicate(AnimationState<E> state) {
        if (this.isSucking()) {
            return PlayState.STOP;
        }
        if (this.swinging) {
            state.getController().forceAnimationReset();
            return state.setAndContinue(RawAnimation.begin().thenPlay("attack"));
        }
        return PlayState.STOP;
    }

    private <E extends GeoAnimatable> PlayState suckPredicate(AnimationState<E> state) {
        if (this.isSucking()) {
            return state.setAndContinue(RawAnimation.begin().thenLoop("suck"));
        }
        return PlayState.STOP;
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.triggerAnim("triggers", animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "move", 5, this::movementPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attack", 0, this::attackPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "suck", 5, this::suckPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "triggers", 0, s -> PlayState.STOP).triggerableAnim("dance", RawAnimation.begin().thenPlay("dance")));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

