/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.event.ironkin;

import net.knifick.praporupdate.init.PraporModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="prapor")
public class UpgradeActivator {
    @SubscribeEvent
    public static void onItemBurned(EntityTickEvent.Pre event) {
        BlockPos pos;
        ItemEntity itemEntity;
        Entity entity = event.getEntity();
        if (!(entity instanceof ItemEntity) || (itemEntity = (ItemEntity)entity).getItem().getItem() != PraporModItems.UPGRADE_INACTIVE.get()) {
            return;
        }
        Level world = entity.level();
        BlockState blockState = world.getBlockState(pos = entity.blockPosition());
        Block block = blockState.getBlock();
        if (block == Blocks.LAVA || block == Blocks.FIRE || block == Blocks.SOUL_FIRE) {
            ItemStack newStack = new ItemStack((ItemLike)PraporModItems.UPGRADE_ACTIVE.get(), itemEntity.getItem().getCount());
            ItemEntity newEntity = new ItemEntity(world, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), newStack);
            world.playSound(null, entity.blockPosition(), SoundEvents.GENERIC_BURN, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!world.isClientSide && world instanceof ServerLevel) {
                ServerLevel level_ = (ServerLevel)world;
                level_.sendParticles((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 20, 0.5, 0.5, 0.5, 0.05);
            }
            newEntity.setDeltaMovement(0.0, 0.3, 0.0);
            world.addFreshEntity((Entity)newEntity);
            itemEntity.discard();
        }
    }
}

