/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.event.pooker;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.knifick.praporupdate.entity.PookerEntity;
import net.knifick.praporupdate.init.PraporModSounds;
import net.knifick.praporupdate.item.GuideBookItem;
import net.knifick.praporupdate.network.PraporModVariables;
import net.knifick.praporupdate.procedures.FrameReturnerProcedure;
import net.knifick.praporupdate.procedures.PookerPerTickProcedure;
import net.knifick.praporupdate.util.ironkin.ScreenShakeUtil;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.SpyglassItem;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class LookAtPookerHandler {
    private static final double REACH_DISTANCE = 900.0;
    private static final ResourceLocation POOKER_ADVANCEMENT = ResourceLocation.parse((String)"prapor:pooker_achieve");
    private static final ResourceLocation POOKER_SOUND = ResourceLocation.parse((String)"prapor:pooker_dissapear");
    private static final ResourceLocation VIGNETTE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"textures/screens/vignette.png");
    private static final float SPEED = 1.0f;
    private static final float FADE_SPEED = 8.0E-4f;
    private static long startTime = System.nanoTime();
    private static float pulseAlpha = 0.0f;
    private static float targetAlpha = 0.0f;
    private static boolean fadingOut = false;
    private static float mult = 0.0f;
    private static final float fade = 0.05f;

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        Entity target = LookAtPookerHandler.getLookedAtEntity(player, 900.0);
        if (target instanceof PookerEntity) {
            PookerEntity pooker = (PookerEntity)target;
            if (!LookAtPookerHandler.isSpectator((Entity)player)) {
                LookAtPookerHandler.handleLookAtPooker(player, pooker);
                return;
            }
        }
        PraporModVariables.PlayerVariables vars = (PraporModVariables.PlayerVariables)player.getData(PraporModVariables.PLAYER_VARIABLES);
        vars.isSee = false;
        vars.syncPlayerVariables((Entity)player);
    }

    private static Entity getLookedAtEntity(Player player, double reachDistance) {
        Vec3 eyePos = player.getEyePosition(1.0f);
        Vec3 lookVec = player.getLookAngle();
        Vec3 endPos = eyePos.add(lookVec.scale(reachDistance));
        AABB searchBox = new AABB(eyePos, endPos);
        List candidates = player.level().getEntities((Entity)player, searchBox, entity -> !entity.isSpectator() && entity.isPickable());
        Entity closest = null;
        double closestDist = reachDistance;
        for (Entity entity2 : candidates) {
            double dist;
            AABB box = entity2.getBoundingBox().inflate((double)entity2.getPickRadius());
            Vec3 hit = box.clip(eyePos, endPos).orElse(null);
            if (hit == null || !((dist = eyePos.distanceTo(hit)) < closestDist)) continue;
            closestDist = dist;
            closest = entity2;
        }
        return closest;
    }

    private static boolean isSpectator(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            return sp.gameMode.getGameModeForPlayer() == GameType.SPECTATOR;
        }
        if (entity.level().isClientSide() && entity instanceof Player) {
            Player p = (Player)entity;
            PlayerInfo info = Minecraft.getInstance().getConnection().getPlayerInfo(p.getGameProfile().getId());
            return info != null && info.getGameMode() == GameType.SPECTATOR;
        }
        return false;
    }

    private static void handleLookAtPooker(Player player, PookerEntity pooker) {
        GuideBookItem.addToBook(player, (LivingEntity)pooker, 1);
        if (player.isUsingItem() && player.getUseItem().getItem() instanceof SpyglassItem) {
            LookAtPookerHandler.grantAdvancement(player, POOKER_ADVANCEMENT);
        }
        if (player.tickCount % 20 == 0) {
            player.playSound(SoundEvents.WARDEN_HEARTBEAT);
        }
        double distance = player.distanceTo((Entity)pooker);
        System.out.println(distance);
        if (distance < 15.0) {
            PookerPerTickProcedure.handlePlayerInteraction(player, (Entity)pooker);
        }
        PraporModVariables.PlayerVariables vars = (PraporModVariables.PlayerVariables)player.getData(PraporModVariables.PLAYER_VARIABLES);
        vars.isSee = true;
        vars.syncPlayerVariables((Entity)player);
        player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 2, 2));
    }

    private static void grantAdvancement(Player player, ResourceLocation id) {
        ServerPlayer sp;
        if (!(player instanceof ServerPlayer) || !((sp = (ServerPlayer)player).level() instanceof ServerLevel)) {
            return;
        }
        AdvancementHolder adv = sp.server.getAdvancements().get(id);
        AdvancementProgress progress = sp.getAdvancements().getOrStartProgress(adv);
        if (!progress.isDone()) {
            for (String criteria : progress.getRemainingCriteria()) {
                sp.getAdvancements().award(adv, criteria);
            }
        }
    }

    private static void playSound(Player player, double x, double y, double z, ResourceLocation sound) {
        if (!player.level().isClientSide()) {
            player.level().playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(sound), SoundSource.MASTER, 1.0f, 1.0f);
        } else {
            player.level().playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(sound), SoundSource.MASTER, 1.0f, 1.0f, false);
        }
    }

    public static void screamer(PookerEntity pooker, Player player) {
        double x = pooker.getX();
        double y = pooker.getY();
        double z = pooker.getZ();
        FrameReturnerProcedure.execute((LevelAccessor)player.level(), (Entity)player, 200.0);
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, x, y + 1.5, z, 300, 1.0, 1.0, 1.0, 0.05);
        }
        player.playSound((SoundEvent)PraporModSounds.POOKER_DISSAPEAR.get());
        if (!pooker.level().isClientSide()) {
            pooker.discard();
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiLayerEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        PraporModVariables.PlayerVariables vars = (PraporModVariables.PlayerVariables)mc.player.getData(PraporModVariables.PLAYER_VARIABLES);
        GuiGraphics gui = event.getGuiGraphics();
        int w = gui.guiWidth();
        int h = gui.guiHeight();
        boolean hasFearEffect = vars.isSee;
        if (hasFearEffect) {
            float pulse;
            long currentTime = System.nanoTime();
            float elapsedSeconds = (float)(currentTime - startTime) / 1.0E9f;
            targetAlpha = pulse = (float)(0.5 + 0.5 * Math.sin((double)elapsedSeconds * Math.PI * 1.0));
        } else {
            targetAlpha = 0.0f;
        }
        if (pulseAlpha < targetAlpha) {
            pulseAlpha = Math.min(targetAlpha, pulseAlpha + 8.0E-4f);
        } else if (pulseAlpha > targetAlpha) {
            pulseAlpha = Math.max(targetAlpha, pulseAlpha - 8.0E-4f);
        }
        if (pulseAlpha > 0.01f) {
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)pulseAlpha);
            gui.blit(VIGNETTE_TEXTURE, 0, 0, 0.0f, 0.0f, w, h, w, h);
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
        }
    }

    @SubscribeEvent
    public static void onComputeFov(ViewportEvent.ComputeFov event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        PraporModVariables.PlayerVariables vars = (PraporModVariables.PlayerVariables)mc.player.getData(PraporModVariables.PLAYER_VARIABLES);
        if (vars.isSee) {
            if (mult < 50.0f) {
                mult += 0.05f;
            }
        } else if (mult > 0.0f) {
            mult -= 0.2f;
        }
        double fov = event.getFOV();
        event.setFOV(fov -= (double)mult);
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        PraporModVariables.PlayerVariables vars = (PraporModVariables.PlayerVariables)mc.player.getData(PraporModVariables.PLAYER_VARIABLES);
        if (vars.isSee && mc.player.tickCount % 10 == 0) {
            ScreenShakeUtil.startShake(10, 3.0f);
        }
    }
}

