/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.event.server;

import java.util.List;
import net.knifick.praporupdate.init.PraporModItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;

@EventBusSubscriber
public class AdvancmentsReward {
    public static ResourceLocation getRecipeIdForItem(ItemStack stack, Player player, MinecraftServer server) {
        if (stack.getItem() == Items.COMPARATOR || stack.getItem() == Items.IRON_INGOT || stack.getItem() == Items.REPEATER || stack.getItem() == PraporModItems.COPPER_WIRE.get() || stack.getItem() == Items.REDSTONE || stack.getItem() == Items.REDSTONE_BLOCK) {
            return ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"battery_craft");
        }
        if (stack.getItem() == PraporModItems.OXIDIZEDCOPPERSHEET.get() || stack.getItem() == Items.GOLD_INGOT) {
            return ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"board_craft");
        }
        if (stack.getItem() == Items.NETHER_BRICK || stack.getItem() == PraporModItems.SPAWNER_SHARD.get() || stack.getItem() == Items.NETHER_STAR) {
            return ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"casket_of_souls_craft");
        }
        if (stack.getItem() == Items.COPPER_INGOT || stack.getItem() == Items.STICK) {
            return ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"copper_wire_craft");
        }
        if (stack.getItem() == Items.GOLD_BLOCK || stack.getItem() == Items.GOLD_INGOT || stack.getItem() == Items.NETHER_STAR) {
            return ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"gold_trophy");
        }
        if (stack.getItem() == Items.RABBIT_HIDE || stack.getItem() == Items.STRING || stack.getItem() == Items.PAPER) {
            return ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"guide1");
        }
        if (stack.is(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"copper_craft_rag")))) {
            return ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"oxidized_copper_ingot_craft");
        }
        if (stack.getItem() == PraporModItems.OXIDIZED_COPPER_INGOT.get()) {
            return ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"oxidized_copper_sheet_craft");
        }
        return null;
    }

    public static void grantRecipe(Player player, MinecraftServer server, ResourceLocation recipeId) {
        if (recipeId == null || server == null) {
            return;
        }
        server.getRecipeManager().byKey(recipeId).ifPresent(recipe -> player.awardRecipes(List.of(recipe)));
    }

    @SubscribeEvent
    public static void onItemPickup(ItemEntityPickupEvent.Pre event) {
        Player player = event.getPlayer();
        if (player.level().isClientSide) {
            return;
        }
        MinecraftServer server = player.level().getServer();
        if (server == null) {
            return;
        }
        ItemStack stack = event.getItemEntity().getItem();
        ResourceLocation recipeId = AdvancmentsReward.getRecipeIdForItem(stack, player, server);
        AdvancmentsReward.grantRecipe(player, server, recipeId);
    }
}

