/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.event.server;

import java.util.Map;
import net.knifick.praporupdate.PraporMod;
import net.knifick.praporupdate.init.PraporModItems;
import net.knifick.praporupdate.network.PraporModVariables;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="prapor")
public class PlayerJoinHandler {
    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!player2.getPersistentData().getBoolean("prapor:hasJoined")) {
            player2.getPersistentData().putBoolean("prapor:hasJoined", true);
            ItemStack stack = new ItemStack((ItemLike)PraporModItems.GUIDE_BOOK.get());
            if (!player2.addItem(stack)) {
                player2.drop(stack, false);
            }
        }
    }

    @SubscribeEvent
    public static void writeAdvancmentTrigger(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        PraporModVariables.PlayerVariables vars = (PraporModVariables.PlayerVariables)player.getData(PraporModVariables.PLAYER_VARIABLES);
        if (vars.seenMobs == null) {
            return;
        }
        int count = 0;
        for (Map.Entry<String, Integer> entry : vars.seenMobs.entrySet()) {
            if (entry.getValue() == 0) continue;
            ++count;
        }
        ResourceLocation resourceLocation = null;
        if (count >= vars.seenMobs.size()) {
            resourceLocation = ResourceLocation.parse((String)"prapor:thanks_scientist");
        } else if (count > 7) {
            resourceLocation = ResourceLocation.parse((String)"prapor:mastermind");
        } else if (count > 3) {
            resourceLocation = ResourceLocation.parse((String)"prapor:advanced_explorer");
        } else if (count == 1) {
            resourceLocation = ResourceLocation.parse((String)"prapor:beginner_explorer");
        }
        if (resourceLocation == null) {
            return;
        }
        AdvancementHolder adv = player.server.getAdvancements().get(resourceLocation);
        if (adv == null) {
            PraporMod.LOGGER.warn("Advancement {} not found!", (Object)resourceLocation);
            return;
        }
        AdvancementProgress ap = player.getAdvancements().getOrStartProgress(adv);
        if (!ap.isDone()) {
            for (String criteria : ap.getRemainingCriteria()) {
                player.getAdvancements().award(adv, criteria);
            }
        }
    }
}

