/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.goal;

import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class AlwaysLookAtPlayerGoal
extends Goal {
    private final Mob mob;
    private Player targetPlayer;

    public AlwaysLookAtPlayerGoal(Mob mob) {
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        this.targetPlayer = this.mob.level().getNearestPlayer((Entity)this.mob, 128.0);
        return this.targetPlayer != null;
    }

    public boolean canContinueToUse() {
        return this.targetPlayer != null && this.targetPlayer.isAlive() && (double)this.mob.distanceTo((Entity)this.targetPlayer) <= 128.0 && this.mob.hasLineOfSight((Entity)this.targetPlayer);
    }

    public void tick() {
        this.mob.lookAt(EntityAnchorArgument.Anchor.EYES, new Vec3(this.targetPlayer.getX(), this.targetPlayer.getY(), this.targetPlayer.getZ()));
    }
}

