/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.goal;

import java.util.EnumSet;
import net.knifick.praporupdate.PraporMod;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import org.apache.logging.log4j.Logger;

public class DirectMeleeAttackGoal
extends Goal {
    private static final Logger LOGGER = PraporMod.LOGGER;
    private final PathfinderMob mob;
    private final double speedModifier;
    private final boolean followEvenIfNotSeen;
    private Path path;
    private double lastPathedX;
    private double lastPathedY;
    private double lastPathedZ;
    private int ticksUntilNextPathRecalc;
    private int ticksUntilNextAttack;
    private long lastCanUseCheck;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = true;
    private boolean usingDirectChase = false;
    private double lastDistanceSqToTarget = Double.MAX_VALUE;
    private int stuckTicks = 0;
    private int fallbackTicks = 0;
    private int lastSetWantedTick = 0;
    private double lastWantedX = Double.NaN;
    private double lastWantedY = Double.NaN;
    private double lastWantedZ = Double.NaN;
    private static final int DEFAULT_ATTACK_COOLDOWN = 20;

    public DirectMeleeAttackGoal(PathfinderMob mob, double speedModifier, boolean followEvenIfNotSeen) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.followEvenIfNotSeen = followEvenIfNotSeen;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        long time = this.mob.level().getGameTime();
        if (time - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = time;
        LivingEntity target = this.mob.getTarget();
        if (target == null) {
            return false;
        }
        if (!target.isAlive()) {
            return false;
        }
        this.path = this.mob.getNavigation().createPath((Entity)target, 0);
        return this.path != null || this.mob.isWithinMeleeAttackRange(target);
    }

    public boolean canContinueToUse() {
        Player p;
        LivingEntity target = this.mob.getTarget();
        if (target == null) {
            return false;
        }
        if (!target.isAlive()) {
            return false;
        }
        if (!this.followEvenIfNotSeen) {
            return !this.mob.getNavigation().isDone();
        }
        return !(target instanceof Player) || !(p = (Player)target).isSpectator() && !p.isCreative();
    }

    public void start() {
        this.mob.setAggressive(true);
        this.ticksUntilNextPathRecalc = 0;
        this.ticksUntilNextAttack = 0;
        this.usingDirectChase = false;
        this.lastDistanceSqToTarget = Double.MAX_VALUE;
        this.stuckTicks = 0;
        this.fallbackTicks = 0;
        this.lastSetWantedTick = 0;
        this.lastWantedX = Double.NaN;
        if (this.path != null) {
            double realSpeed = this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED) * this.speedModifier;
            this.mob.getNavigation().moveTo(this.path, realSpeed);
        }
    }

    public void stop() {
        LivingEntity target = this.mob.getTarget();
        if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(target)) {
            this.mob.setTarget(null);
        }
        this.mob.setAggressive(false);
        this.mob.getNavigation().stop();
        this.usingDirectChase = false;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        LivingEntity target = this.mob.getTarget();
        if (target == null) {
            return;
        }
        this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        this.ticksUntilNextPathRecalc = Math.max(this.ticksUntilNextPathRecalc - 1, 0);
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        if (this.fallbackTicks > 0) {
            --this.fallbackTicks;
        }
        double dx = target.getX() - this.mob.getX();
        double dy = target.getY() - (this.mob.getY() + (double)this.mob.getEyeHeight());
        double dz = target.getZ() - this.mob.getZ();
        double distanceSq = dx * dx + dy * dy + dz * dz;
        boolean canSee = this.mob.getSensing().hasLineOfSight((Entity)target);
        if (canSee && this.fallbackTicks == 0) {
            boolean tickAllow;
            if (!this.usingDirectChase) {
                this.usingDirectChase = true;
                this.mob.getNavigation().stop();
                this.lastDistanceSqToTarget = Double.MAX_VALUE;
                this.stuckTicks = 0;
            }
            MoveControl mc = this.mob.getMoveControl();
            float realSpeed = (float)(this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED) * this.speedModifier);
            boolean targetMoved = Double.isNaN(this.lastWantedX) || target.distanceToSqr(this.lastWantedX, this.lastWantedY, this.lastWantedZ) > 0.0625;
            boolean bl = tickAllow = this.mob.level().getGameTime() - (long)this.lastSetWantedTick >= 3L;
            if (targetMoved || tickAllow) {
                mc.setWantedPosition(target.getX(), target.getY(), target.getZ(), (double)realSpeed);
                this.lastSetWantedTick = (int)this.mob.level().getGameTime();
                this.lastWantedX = target.getX();
                this.lastWantedY = target.getY();
                this.lastWantedZ = target.getZ();
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("DirectMelee: setWantedPosition tick={}, tx={}, tz={}, moved={}, tickAllow={}, realSpeed={}", (Object)this.lastSetWantedTick, (Object)this.lastWantedX, (Object)this.lastWantedZ, (Object)targetMoved, (Object)tickAllow, (Object)Float.valueOf(realSpeed));
                }
            }
            this.stuckTicks = distanceSq + 1.0E-6 >= this.lastDistanceSqToTarget ? ++this.stuckTicks : 0;
            this.lastDistanceSqToTarget = distanceSq;
            if (this.stuckTicks >= 10) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("DirectMeleeAttackGoal: detected stuck, switching to pathfinding fallback. stuckTicks={}, distanceSq={}", (Object)this.stuckTicks, (Object)distanceSq);
                }
                this.usingDirectChase = false;
                this.fallbackTicks = 20 + this.mob.getRandom().nextInt(20);
                double realSpeedD = this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED) * this.speedModifier;
                boolean moved = this.mob.getNavigation().moveTo((Entity)target, realSpeedD);
                if (!moved) {
                    this.failedPathFindingPenalty += 10;
                }
                return;
            }
        } else {
            if (this.usingDirectChase) {
                this.usingDirectChase = false;
            }
            if ((this.followEvenIfNotSeen || canSee) && this.ticksUntilNextPathRecalc <= 0 && (this.lastPathedX == 0.0 && this.lastPathedY == 0.0 && this.lastPathedZ == 0.0 || target.distanceToSqr(this.lastPathedX, this.lastPathedY, this.lastPathedZ) >= 1.0 || this.mob.getRandom().nextFloat() < 0.05f)) {
                this.lastPathedX = target.getX();
                this.lastPathedY = target.getY();
                this.lastPathedZ = target.getZ();
                this.ticksUntilNextPathRecalc = 4 + this.mob.getRandom().nextInt(7);
                double d0 = this.mob.distanceToSqr((Entity)target);
                if (this.canPenalize) {
                    Path p;
                    this.ticksUntilNextPathRecalc += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.mob.getNavigation().getPath() != null ? ((p = this.mob.getNavigation().getPath()).getEndNode() != null && target.distanceToSqr((double)p.getEndNode().x, (double)p.getEndNode().y, (double)p.getEndNode().z) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalc += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalc += 5;
                }
                double realSpeedD = this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED) * this.speedModifier;
                if (!this.mob.getNavigation().moveTo((Entity)target, realSpeedD)) {
                    this.ticksUntilNextPathRecalc += 15;
                }
                this.ticksUntilNextPathRecalc = this.adjustedTickDelay(this.ticksUntilNextPathRecalc);
            }
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        this.checkAndPerformAttack(target);
    }

    protected void checkAndPerformAttack(LivingEntity target) {
        if (this.canPerformAttack(target)) {
            this.resetAttackCooldown();
            this.mob.swing(InteractionHand.MAIN_HAND);
            this.mob.doHurtTarget((Entity)target);
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.adjustedTickDelay(20);
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean canPerformAttack(LivingEntity target) {
        return this.isTimeToAttack() && this.mob.isWithinMeleeAttackRange(target) && this.mob.getSensing().hasLineOfSight((Entity)target);
    }

    public int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }
}

