/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.item;

import net.knifick.praporupdate.client.screens.BookScreen;
import net.knifick.praporupdate.entity.BastardEntity;
import net.knifick.praporupdate.entity.BobEntity;
import net.knifick.praporupdate.entity.BrolemEntity;
import net.knifick.praporupdate.entity.DarkironkinEntity;
import net.knifick.praporupdate.entity.NarratorEntity;
import net.knifick.praporupdate.entity.NymphEntity;
import net.knifick.praporupdate.entity.PraporEntity;
import net.knifick.praporupdate.entity.SoulEntity;
import net.knifick.praporupdate.entity.SuckerEntity;
import net.knifick.praporupdate.network.PraporModVariables;
import net.knifick.praporupdate.network.payloads.ToastPayload;
import net.knifick.praporupdate.toast.MobToast;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class GuideBookItem
extends Item {
    public GuideBookItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.RARE));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide) {
            PraporModVariables.PlayerVariables vars = (PraporModVariables.PlayerVariables)player.getData(PraporModVariables.PLAYER_VARIABLES);
            vars.syncPlayerVariables((Entity)player);
            return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
        }
        Minecraft.getInstance().setScreen((Screen)new BookScreen((Component)Component.literal((String)"\u0413\u0430\u0439\u0434")));
        return super.use(level, player, hand);
    }

    public InteractionResult interactLivingEntity(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        if (player.level().isClientSide) {
            return InteractionResult.sidedSuccess((boolean)true);
        }
        if (!(livingEntity instanceof BastardEntity || livingEntity instanceof BobEntity || livingEntity instanceof BrolemEntity || livingEntity instanceof DarkironkinEntity || livingEntity instanceof NarratorEntity || livingEntity instanceof NymphEntity || livingEntity instanceof PraporEntity || livingEntity instanceof SoulEntity || livingEntity instanceof SuckerEntity)) {
            return InteractionResult.FAIL;
        }
        GuideBookItem.addToBook(player, livingEntity, 1);
        return InteractionResult.sidedSuccess((boolean)false);
    }

    public static void addToBook(Player player, LivingEntity entity, int value) {
        PraporModVariables.PlayerVariables vars = (PraporModVariables.PlayerVariables)player.getData(PraporModVariables.PLAYER_VARIABLES);
        ResourceLocation id = entity.getType().builtInRegistryHolder().key().location();
        String mobName = id.getPath();
        int currentValue = vars.seenMobs.getOrDefault(mobName, 0);
        if (currentValue >= value) {
            return;
        }
        if (value > currentValue + 1) {
            return;
        }
        vars.seenMobs.put(mobName, value);
        vars.syncPlayerVariables((Entity)player);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ToastPayload(mobName), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void showToast(String name) {
        PraporModVariables.PlayerVariables vars = (PraporModVariables.PlayerVariables)Minecraft.getInstance().player.getData(PraporModVariables.PLAYER_VARIABLES);
        Minecraft mc = Minecraft.getInstance();
        mc.player.playSound(SoundEvents.VILLAGER_WORK_CARTOGRAPHER);
        ToastComponent toastGui = mc.getToasts();
        String info = "\u041d\u043e\u0432\u044b\u0439 \u043c\u043e\u0431: ";
        if (vars.seenMobs.get(name) > 1) {
            info = "\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u043e: ";
        }
        toastGui.addToast((Toast)new MobToast((Component)Component.literal((String)info).append((Component)Component.translatable((String)("entity.prapor." + name))), ResourceLocation.parse((String)"prapor:textures/entity/prapor.png")));
    }
}

