/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.item;

import net.knifick.praporupdate.init.PraporModSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SoulBucket
extends Item {
    private final EntityType<? extends Mob> type;

    public SoulBucket(EntityType<? extends Mob> type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        Minecraft mc = Minecraft.getInstance();
        mc.player.playSound((SoundEvent)PraporModSounds.SOUL_SOUNDS.get(), 1.0f, 1.0f);
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos().relative(context.getClickedFace());
        level.playSound(context.getPlayer(), pos, (SoundEvent)PraporModSounds.SOUL_SOUNDS.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        this.type.spawn(serverLevel, stack, context.getPlayer(), pos, MobSpawnType.SPAWN_EGG, true, false);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!serverPlayer.gameMode.isCreative()) {
                player.setItemInHand(context.getHand(), new ItemStack((ItemLike)Items.BUCKET));
            }
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        return super.use(level, player, hand);
    }
}

