/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.item.model;

import net.knifick.praporupdate.item.MantleItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;

public class MantleModel
extends GeoModel<MantleItem> {
    public ResourceLocation getAnimationResource(MantleItem object) {
        return ResourceLocation.parse((String)"prapor:animations/mantle.animation.json");
    }

    public ResourceLocation getModelResource(MantleItem object) {
        return ResourceLocation.parse((String)"prapor:geo/mantle.geo.json");
    }

    public ResourceLocation getTextureResource(MantleItem object) {
        return ResourceLocation.parse((String)"prapor:textures/armor/mantle_armor.png");
    }

    public void setCustomAnimations(MantleItem animatable, long instanceId, AnimationState animationState) {
        LivingEntity wearer = (LivingEntity)animationState.getData(DataTickets.ENTITY);
        if (wearer == null) {
            return;
        }
        GeoBone m1 = this.getAnimationProcessor().getBone("m1");
        GeoBone m2 = this.getAnimationProcessor().getBone("m2");
        GeoBone m3 = this.getAnimationProcessor().getBone("m3");
        GeoBone m4 = this.getAnimationProcessor().getBone("m4");
        float ageInTicks = (float)wearer.tickCount + animationState.getPartialTick();
        float speed = (float)wearer.getDeltaMovement().length();
        float motionY = (float)wearer.getDeltaMovement().y;
        float targetPitch = motionY * 1.3f;
        float maxUp = -0.1f;
        float maxDown = -0.6f;
        targetPitch = Mth.clamp((float)targetPitch, (float)maxDown, (float)maxUp);
        float smoothFactor = 0.1f;
        if (m1 != null) {
            m1.setRotX(m1.getRotX() + (targetPitch - m1.getRotX() * 0.35f) * smoothFactor);
        }
        if (m2 != null) {
            m2.setRotX(m2.getRotX() + (targetPitch - m2.getRotX()) * smoothFactor);
        }
        if (m3 != null) {
            m3.setRotX(m3.getRotX() + (targetPitch - m3.getRotX()) * smoothFactor);
        }
        if (m4 != null) {
            m4.setRotX(m4.getRotX() + (targetPitch - m4.getRotX()) * smoothFactor);
        }
        float baseAmplitude = 0.005f;
        float waveSpeed = 0.1f;
        if (m1 != null) {
            m1.setRotX(m1.getRotX() + (float)Math.sin(ageInTicks * waveSpeed + 1.0f) * baseAmplitude);
        }
        if (m2 != null) {
            m2.setRotX(m2.getRotX() + (float)Math.sin(ageInTicks * waveSpeed + 1.4f) * baseAmplitude);
        }
        if (m3 != null) {
            m3.setRotX(m3.getRotX() + (float)Math.sin(ageInTicks * waveSpeed + 1.9f) * baseAmplitude);
        }
        if (m4 != null) {
            m4.setRotX(m4.getRotX() + (float)Math.sin(ageInTicks * waveSpeed + 2.4f) * baseAmplitude);
        }
    }
}

