/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.procedures;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EnchantmentGiverProcedure {
    public static void execute(ServerPlayer player) {
        ItemStack heldItem = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (heldItem.getItem() != Items.ENCHANTED_BOOK) {
            return;
        }
        ItemEnchantments enchantments = (ItemEnchantments)heldItem.get(DataComponents.STORED_ENCHANTMENTS);
        ItemStack newBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        boolean upgraded = false;
        Level world = player.level();
        for (Object2IntMap.Entry entry : enchantments.entrySet()) {
            Enchantment enchantment = (Enchantment)((Holder)entry.getKey()).value();
            int currentLevel = entry.getValue();
            int maxLevel = enchantment.getMaxLevel();
            if (maxLevel > 1 && currentLevel < maxLevel) {
                int newLevel = Math.min(currentLevel + 1, maxLevel);
                if (!world.isClientSide()) {
                    newBook.enchant((Holder)entry.getKey(), newLevel);
                }
                upgraded = true;
                continue;
            }
            if (world.isClientSide()) continue;
            newBook.enchant((Holder)entry.getKey(), currentLevel);
        }
        if (upgraded) {
            player.setItemInHand(InteractionHand.MAIN_HAND, newBook);
            player.getInventory().setChanged();
        }
    }
}

