/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.procedures;

import java.util.Comparator;
import net.knifick.praporupdate.entity.PookerEntity;
import net.knifick.praporupdate.event.pooker.LookAtPookerHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PookerPerTickProcedure {
    private static final ResourceLocation POOKER_SOUND = ResourceLocation.parse((String)"prapor:pooker_dissapear");

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        PookerPerTickProcedure.spawnIdleParticles(world, x, y, z);
        if (PookerPerTickProcedure.shouldVanishInDay(world)) {
            PookerPerTickProcedure.spawnSmokeBurst(world, x, y + 1.5, z);
            PookerPerTickProcedure.discardEntity(entity);
            return;
        }
        Player nearestPlayer = PookerPerTickProcedure.findNearestPlayer(world, x, y, z, 20.0);
        if (nearestPlayer != null && !PookerPerTickProcedure.isSpectator((Entity)nearestPlayer)) {
            PookerPerTickProcedure.handlePlayerInteraction(nearestPlayer, entity);
        }
    }

    private static void spawnIdleParticles(LevelAccessor world, double x, double y, double z) {
        if (world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            level.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, x, y, z, 20, 0.5, 0.5, 0.5, 0.01);
            level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 1, 3.0, 3.0, 3.0, 0.05);
        }
    }

    private static boolean shouldVanishInDay(LevelAccessor world) {
        if (world instanceof Level) {
            Level level = (Level)world;
            return level.isDay() && !world.getLevelData().isThundering();
        }
        return false;
    }

    public static void spawnSmokeBurst(LevelAccessor world, double x, double y, double z) {
        if (world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            level.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, x, y, z, 600, 1.0, 1.0, 1.0, 0.0);
        }
    }

    private static Player findNearestPlayer(LevelAccessor world, double x, double y, double z, double range) {
        return world.getEntitiesOfClass(Player.class, AABB.ofSize((Vec3)new Vec3(x, y, z), (double)range, (double)range, (double)range)).stream().min(Comparator.comparingDouble(e -> e.distanceToSqr(x, y, z))).orElse(null);
    }

    private static boolean isSpectator(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            return sp.gameMode.getGameModeForPlayer() == GameType.SPECTATOR;
        }
        if (entity.level().isClientSide() && entity instanceof Player) {
            Player p = (Player)entity;
            PlayerInfo info = Minecraft.getInstance().getConnection().getPlayerInfo(p.getGameProfile().getId());
            return info != null && info.getGameMode() == GameType.SPECTATOR;
        }
        return false;
    }

    public static void handlePlayerInteraction(Player player, Entity entity) {
        if (entity.tickCount % 10 == 0 && !player.level().isClientSide) {
            Level level;
            double maxDistance;
            float maxDamage = 10.0f;
            double distance = player.distanceTo(entity);
            double clamped = Math.min(distance, maxDistance = 20.0);
            float damage = (float)((double)maxDamage * (1.0 - clamped / maxDistance));
            if (damage > 0.0f) {
                if (player.getHealth() - damage > 0.0f) {
                    player.hurt(entity.damageSources().magic(), damage);
                } else if (!player.isCreative()) {
                    LookAtPookerHandler.screamer((PookerEntity)entity, player);
                }
            }
            if ((level = player.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, player.getX(), player.getY() + 1.0, player.getZ(), 50, 1.0, 1.0, 1.0, 0.0);
            }
        }
    }

    private static void playSound(LevelAccessor world, double x, double y, double z, ResourceLocation sound) {
        if (world instanceof Level) {
            Level level = (Level)world;
            if (!level.isClientSide()) {
                level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(sound), SoundSource.MASTER, 1.0f, 1.0f);
            } else {
                level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(sound), SoundSource.MASTER, 1.0f, 1.0f, false);
            }
        }
    }

    private static void discardEntity(Entity entity) {
        if (!entity.level().isClientSide()) {
            entity.discard();
        }
    }
}

