/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.toast;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class MobToast
implements Toast {
    private final Component mobName;
    private final ResourceLocation mobIcon;
    private long firstDrawTime = -1L;
    private static final ResourceLocation TOAST_BG = ResourceLocation.fromNamespaceAndPath((String)"prapor", (String)"textures/screens/toast.png");

    public MobToast(Component mobName, ResourceLocation mobIcon) {
        this.mobName = mobName;
        this.mobIcon = mobIcon;
    }

    public Toast.Visibility render(GuiGraphics guiGraphics, ToastComponent toastGui, long delta) {
        if (this.firstDrawTime == -1L) {
            this.firstDrawTime = delta;
        }
        guiGraphics.blit(TOAST_BG, 0, 0, 0.0f, 0.0f, 160, 32, 160, 32);
        Font font = Minecraft.getInstance().font;
        List lines = font.split((FormattedText)this.mobName, 120);
        int y = 8;
        for (int i = 0; i < lines.size() && i < 2; ++i) {
            guiGraphics.drawString(font, (FormattedCharSequence)lines.get(i), 30, y, 0xFFFFFF, false);
            y += 10;
        }
        return delta - this.firstDrawTime >= 5000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

